from linda import checks, common

class StandardsVersionCheck(checks.LindaChecker):
    'Check the Standards-Version field.'
    def check_source_1(self):
        try:
            check_st_ver = {'out-of-date': [3, 1], 'newer': [3, 6, 1]}
            s_v = common.dsc['standards-version'].split('.')
            pp_s_v = ".".join(s_v)
            s_v = [int(x) for x in s_v]
            dprint(_("Standards Version: %s") % s_v)
            if len(s_v) < 3:
                self.signal_error('incorrect-standards-version')
            if s_v[0] < 3:
                self.signal_error('ancient-standards-version', [pp_s_v])
            elif s_v[:2] < check_st_ver['out-of-date']:
                self.signal_error('out-date-standards-version', [pp_s_v])
                if common.dsc.has_key('build-depends') or \
                   common.dsc.has_key('build-depends-indep') or \
                   common.dsc.has_key('build-conflicts') or \
                   common.dsc.has_key('build-conflicts-indep'):
                    self.signal_error('build-deps-wrong-s-v')
            elif s_v[:3] > check_st_ver['newer']:
                self.signal_error('newer-standards-version', [pp_s_v])
        except KeyError:
            self.signal_error('no-standards-version')

checks.register(StandardsVersionCheck)

