from linda import checks, common

class ShebangCheck(checks.LindaChecker):
    'Check the maintainer scripts are using correct depends.'
    def check_binary_2(self):
        for i in ('postinst', 'preinst', 'prerm', 'postrm', 'config'):
            try:
                f = open('./control/' + i)
            except IOError, e:
                dprint(_("Failed to open %s: %s.") % (i, e))
                f = 0
            if f:
                k = f.readline()
                if k.startswith('#!'):
                    opt_sep = k.rfind(' ')
                    path_sep = k.find('/')
                    if opt_sep > path_sep:
                        script_run = k[path_sep:opt_sep]
                    else:
                        script_run = k[path_sep:-1]
                f.close()
                # Element 0 is the string to match with depends, element 1 is 
                # the path.
                if len(script_run) == 0:
                    self.signal_error('no-shebang-line', [i])
                    continue
                script_mapping = {'sh': ['', '/bin'], 'ash': ['ash', '/bin'], \
                    'csh': ['tcsh', '/bin'], 'perl': ['perl'], 'awk': \
                    ['awk'], 'bash': ['', '/bin'], 'bltwish': ['blt'], \
                    'burlap': ['felt'], 'expect': ['expect'], 'gawk': \
                    ['gawk'], 'gforth': ['gforth'],  'gnuplot': ['gnuplot'], \
                    'guile': ['guile'], 'install-menu': ['menu'], \
                    'install-fvwmgenmenu': ['menu'], 'js': ['ngs-js'], \
                    'kforth': ['kforth'], 'ksh': ['pdksh'], 'magicfilter': \
                    ['magicfilter'], 'make': ['make'], 'mawk': ['mawk'], \
                    'ocaml': ['ocaml'], 'pforth': ['pforth'], 'php': \
                    ['php-cgi'], 'pike': ['pike'], 'pike7': ['pike7'], \
                    'python': ['python'], 'python2.1': ['python2.1'], \
                    'python2.2': ['python2.2'], 'rc': ['rc'], 'regina': \
                    ['regina-rexx'], 'rexx': ['regina-rexx'], 'ruby': \
                    ['ruby'], 'runhugs1.4': ['hugs'], 'runhugs98': \
                    ['hugs98'], 'scsh': ['scsh'], 'sed': ['sed', '/bin'], \
                    'suidperl': ['perl-suid'], 'tclsh': ['tclsh'], 'tcsh': \
                    ['tcsh'], 'tixwish': ['tix'], 'trs': ['konwert'], \
                    'yforth': ['yforth'], 'zsh': ['zsh']}
                cur_script_path = script_run[:script_run.rfind('/')]
                cur_script_exec = script_run[script_run.rfind('/')+1:]
                dprint(_("%s; %s") % (i, script_run))
                if cur_script_path.find('usr/local') != -1:
                    self.signal_error('usr-local-interpreter', [i])
                if script_mapping.has_key(cur_script_exec):
                    if common.control.has_key('depends'):
                        if common.control['depends'].has_key(script_mapping\
                            [cur_script_exec][0]):
                            field_name = 'Depends:'
                    if common.control.has_key('pre-depends'):
                        if common.control['pre-depends']\
                            .has_key(script_mapping[cur_script_exec][0]):
                            field_name = 'Pre-Depends:'
		    if not (cur_script_exec == 'sh' or cur_script_exec == \
			'bash' or cur_script_exec == 'perl' or \
                        script_mapping[cur_script_exec][0] == self.pkg_name):
			self.signal_error('script-depends', [i, \
			    cur_script_exec, field_name])
                    if len(script_mapping[cur_script_exec]) == 1:
                        cur_path_scr = '/usr/bin'
                    else:
                        cur_path_scr = script_mapping[cur_script_exec][1]
                    if cur_script_path != cur_path_scr:
                        self.signal_error('wrong-path-script', [i, \
                            cur_script_exec])
                    if cur_script_exec.find('csh') != -1:
                        self.signal_error('csh-harmful', [i])
                else:
                    self.signal_error('unknown-exec', [i, cur_script_exec])
                    continue

checks.register(ShebangCheck)

