from linda import checks, common, dpkgver

class PerlCheck(checks.LindaChecker):
    'Check things regarding to perl.'
    def check_binary_2(self):
        if common.control.has_key('architecture'):
            arch = common.control['architecture']
        else:
            arch = 'none'
        if common.control.has_key('source'):
            src_pkg = common.control['source']
        else:
            src_pkg = self.pkg_name
        stuff_found = {'dep': 0, 'indep': 0, 'wrong_dep' : 0, 'wrong_indep': \
            0, 'perl': 0}
        if self.pkg_name.startswith('lib') and self.pkg_name.endswith('-perl'):
            probable_mod_pkg = 1
        else:
            probable_mod_pkg = 0
        for x in common.files:
            path, file = os.path.splitext(x[1:])
            if path == '/usr/lib/perl' or path == '/usr/share/perl' and \
                src_pkg != 'perl' and not stuff_found['perl']:
                stuff_found['perl'] = 1
                self.signal_error('pkg-installs-into-perl-dir')
            if x.startswith('./usr/lib/perl5') and arch == 'all' and not \
                stuff_found['wrong_dep']:
                stuff_found['wrong_dep'] = 1
                self.signal_error('arch-indep-should-be-u-s-p')
            if x.startswith('./usr/share/perl5') and arch != 'all' and not \
                (aps_not_valid('arch', arch) and stuff_found['wrong_indep']):
                stuff_found['wrong_indep'] = 1
                self.signal_error('arch-dep-should-be-u-l-p')
            if x.startswith('./usr/lib/perl5') and not \
                aps_not_valid('arch', arch) and not stuff_found['dep']:
                stuff_found['dep'] = 1
            if x.startswith('./usr/share/perl5') and arch == 'all' and not \
                stuff_found['indep']:
                stuff_found['indep'] = 1
        dprint(_("Perl: Dep stuff_found: %s") % stuff_found['dep'], 2)
        dprint(_("Perl: Indep stuff_found: %s") % stuff_found['indep'], 2)
        if stuff_found['dep'] and probable_mod_pkg:
            if common.control.has_key('depends'):
                if not (common.control['depends'].has_key('perl') or \
                    common.control['depends'].has_key('perl-base')):
                    self.signal_error('arch-dep-no-dep')
        elif stuff_found['indep'] and probable_mod_pkg:
            if common.control.has_key('depends'):
                if not (common.control['depends'].has_key('perl') or \
                    common.control['depends'].has_key('perl-base')):
                    self.signal_error('arch-indep-no-dep')
                else:
                    if common.control['depends'].has_key('perl'):
                        self.check_indep_depends('perl')
                    elif common.control['depends'].has_key('perl-base'):
                        self.check_indep_depends('perl-base')

    def check_indep_depends(self, perl_dep):
        if common.control['depends'][perl_dep][0] in ('>', '>>', '>='):
            ver_a = dpkgver.DpkgVersion(common.control['depends'][perl_dep][1])
            if ver_a < '5.6.0-16':
                self.signal_error('perl-dep-no-great-enough', [perl_dep])

checks.register(PerlCheck)

