import re
from linda import checks, common

class LibraryCheck(checks.LindaChecker):
    'Checks things regarding shared libraries.'
    def check_binary_2(self):
        number_lib = number_bin = cur_lib = 0
        # This is so I can add other bits of information from objdump
        lib_info = {'soname': []}
        for k in common.output['file'].keys():
            if common.output['file'][k].startswith('ELF ') or \
                (common.output['file'][k].find(' ELF ') != -1):
                if common.output['file'][k].find('LSB shared object') != -1:
                    number_lib += 1
                    cur_lib = 1
                elif common.output['file'][k].find('LSB executable') != -1:
                    number_bin += 1
                # We should only interrogate libraries.
                if cur_lib:
                    if not os.path.islink('./unpacked' + k[1:]) and \
                           k[1:].find('.gz') == -1:
                        path, throw = os.path.split(k[1:])
                        if path in ('/lib', '/usr/lib', \
                            '/usr/lib/libg++-dbg', '/usr/X11R6/lib/Xaw3d', \
                            '/usr/local/lib', '/usr/X11R6/lib', \
                            '/usr/lib/libc5-compat', '/lib/libc5-compat'):
                            if common.output['objdump'][k].find('SONAME') != \
                                -1:
                                cur_soname = common.output['objdump'][k]\
                                    [common.output['objdump'][k].\
                                    find('SONAME'):common.output['objdump']\
                                    [k].find('\n', common.output['objdump']\
                                    [k].find('SONAME'))]
                                munged_so = \
                                    cur_soname.split()[-1].split('.')[0]
                                if munged_so.find('-') != -1:
                                    munged_so = munged_so.split('-')[0]
                                lib_info['soname'].append({'path': path, \
                                    'soname': munged_so})
            cur_lib = 0
        dprint(_("Library Information: %s") % lib_info)
        soname_in_pkg = 0
        for x in lib_info['soname']:
            # Now we can replace.
            if re.search(r'[0-9]\.so\.[0-9]', x['soname']):
                x['soname'] = x['soname'].replace('.so.', '-')
            else:
                x['soname'] = x['soname'].replace('.so.', '')
            if self.pkg_name.find(x['soname'].lower()) != -1:
                soname_in_pkg = 1
        
        pkgname_vs_soname = 0
        if number_lib and not number_bin and lib_info['soname']:
            if common.control['section'] not in ('libs', 'base', 'oldlibs'):
                self.signal_error('section-not-libs')
            if not soname_in_pkg:
                for x in lib_info['soname']:
                    if self.pkg_name.find(x['soname'].lower()) != -1:
                        pkgname_vs_soname = 1
                    if x['soname'].lower().find(self.pkg_name) != -1:
                        pkgname_vs_soname = 1
                # After that, let's test pkgname_vs_soname
                if not pkgname_vs_soname and lib_info['soname']:
                    self.signal_error('package-notlike-soname')
                    if not self.pkg_name.startswith('lib'):
                        self.signal_error('package-not-start-lib')
        for x in common.files:
            if x.endswith('.so') and os.path.islink(x) and not \
                self.pkg_name.endswith('-dev'):
                self.signal_error('so-symlink-non-dev')

checks.register(LibraryCheck)

