import linda, commands, shutil
from linda import checks

class IncludesCheck(checks.LindaChecker):
    'Check that header files of a package are sane.'
    def check_binary_2(self):
        if os.path.isdir(self.lab + '/unpacked/usr/include'):
            tmp_file = commands.getstatusoutput('mktemp')[1]
            diff_file = open(tmp_file, 'w')
            tmp_directory = commands.getstatusoutput('mktemp -d')[1]
            fixinc = commands.getstatusoutput('fixincludes %s %s' % \
                (tmp_directory, self.lab + '/unpacked/usr/include'))[1]
            if os.listdir(tmp_directory):
                diff_output = commands.getstatusoutput('diff -urN %s %s' % \
                    (self.lab + '/unpacked/usr/include', tmp_directory))[1]
                if diff_output:
                    diff_file.write('%s\n' % diff_output)
                    self.signal_error('fixinc-diff-not-empty', [tmp_file])
            shutil.rmtree(tmp_directory)
            diff_file.close()
            if not os.path.getsize(tmp_file):
                os.unlink(tmp_file)

checks.register(IncludesCheck)
