import re, commands
from linda import checks, common
from linda.common import get_dir

class FilesCheck(checks.LindaChecker):
    'Runs checks over binary and source files in packages.'
    def check_binary_2(self):
        os.chdir('./unpacked')
        if not os.path.exists('./usr/share/doc/' + self.pkg_name + \
            '/copyright') and not os.path.islink('./usr/share/doc/' + \
            self.pkg_name):
            self.signal_error('no-copyright')
        if os.path.islink('./usr/share/doc/' + self.pkg_name + '/copyright'):
            self.signal_error('copyright-is-symlink')
        if os.path.exists('./usr/share/doc/copyright/' + self.pkg_name) or \
            os.path.exists('./usr/doc/copyright/' + self.pkg_name):
            self.signal_error('old-copyright-location')
        if os.path.exists('./usr/doc') and os.path.isdir('./usr/doc') and \
            not os.path.exists('./usr/share/doc'):
            self.signal_error('usr-doc-no-usr-share-doc')
        if os.path.exists('./usr/share/doc/' + self.pkg_name + \
            '/examples/examples'):
            self.signal_error('usr-share-doc-double-examples')
        lala = get_dir('.')
        del lala[0]
        for x in lala:
            if os.path.islink(x):
                continue
            if not os.listdir(x) and x.startswith('./usr/share'):
                self.signal_error('empty-directory-in-pkg', [x[1:]])
        try:
            f = open('./usr/share/doc/' + self.pkg_name + '/copyright')
            upstream_authors = re.compile(r'upstream author\(s\)', \
                re.IGNORECASE)
            for k in f.xreadlines():
                if k.find('usr/share/doc/copyright') != -1 or \
                    k.find('usr/doc/copyright') != -1:
                    self.signal_error('copyright-old-directory')
                if k.find('usr/share/common-licences') != -1:
                    self.signal_error('common-licenses')
                if re.search(upstream_authors, k):
                    self.signal_error('upstream-authors')
            f.seek(0)
            k = f.read()
            gpl_raw_text = r'This program is free software; you can ' +\
                'redistribute it and/or modify it under the terms of the ' +\
                'GNU Public License as published by the Free'
            gpl_text = re.compile(gpl_raw_text.replace(' ', '..?'), \
                re.MULTILINE + re.DOTALL)
            gpl_bit = re.compile(r'GNU GENERAL PUBLIC LICENSE\s*TERMS AND' +\
                'CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\b', \
            re.MULTILINE + re.DOTALL)
            if re.search(gpl_text, k):
                if not re.search(r'\/usr\/share\/common-licenses\/.*' +\
                '(Artistic|GPL)', k):
                    self.signal_error('copyright-blurb-no-name')
            if re.search(gpl_bit, k) and len(k) > 12000:
                self.signal_error('copyright-contains-full-gpl')
            if k.find('<fill in ftp site>') != -1 or \
                k.find('<put author(s) name and email here>') != -1:
                self.signal_error('probable-dh-make-template')
            f.close()
            # At this point, 'k' could be quite large. Kill it.
            del k
        except IOError, e:
            dprint(_("Copyright file failed to open: %s.") % e)
        f = 0
        for x in ('/README.Debian', '/README.debian'):
            if os.path.exists('./usr/share/doc/' + self.pkg_name + x):
                if not f:
                    continue
                if os.path.islink('./usr/share/doc/' + self.pkg_name + x):
                    if not os.path.exists(os.readlink('./usr/share/doc/' + \
                        self.pkg_name + x)):
                        continue
                f = open('./usr/share/doc/' + self.pkg_name + x)
        if f:
            for k in f.xreadlines():
                if k.find("<possible notes regarding this package - if " +\
                "none, delete this file>") != -1:
                    self.signal_error('possible-readme-debian-template')
            f.close()
        files_found = {'cvsignore': 0, 'vercon': 0, 'opt': 0, 'usr_local': 0, \
            'usr_share': 0, 'cvs_bu': 0, 'install': 0, 'old-a-d': 0, \
            'arch_all_lib': 0, 'dotxvpics': 0}
        for x in common.output['dirs'].keys():
            if x.find('.xvpics') != -1 and not files_found['dotxvpics']:
                self.signal_error('dot-xvpics-in-package')
                files_found['dotxvpics'] = 1
            if (x.find('/CVS/') != -1 or x.find('/.svn/') != -1) and not \
                files_found['vercon']:
                self.signal_error('vercon-dir-in-package', [x[1:]])
                files_found['vercon'] = 1
            if common.output['dirs'][x] != ['root/root', '0755']:
                self.signal_error('non-standard-dir-perm', \
                    [x[1:]] + common.output['dirs'][x])
            if re.search(r'/var/[^/]+$', x[1:]):
                if re.search(r'^/var/(adm|catman|named|nis|preserve)$', x[1:]):
                    self.signal_error('FSSTND-dir-in-var', [x[1:]])
                else:
                    if not re.search(r'^/var/(account|lib|cache|crash|' +\
                        'games|lock|log|opt|run|spool|state|tmp|www|yp)$', \
                        x[1:]):
                        self.signal_error('non-standard-dir-in-var', [x[1:]])
            elif x == './var/lib/games':
                self.signal_error('non-standard-dir-in-var', [x[1:]])
            elif re.search(r'/usr/[^/]+$', x[1:]):
                if re.search(r'^/usr/(dict|doc|etc|info|man|adm|preserve)$', \
                    x[1:]):
                    self.signal_error('FSSTND-dir-in-usr', [x[1:]])
                else:
                    if not re.search(r'^/usr/(X11R6|X386|bin|games|include|'+\
                        'lib|local|sbin|share|src|spool|tmp)$', x[1:]):
                        self.signal_error('non-standard-dir-in-usr', [x[1:]])
        for x in common.files:
            path, keep = os.path.split(x[1:])
            cur_file_perm = common.output['perms'][x][1]
            if path.startswith('/opt') and not files_found['opt']:
                self.signal_error('file-in-opt')
                files_found['opt'] = 1
            if path.startswith('/usr/local') and not files_found['usr_local']:
                self.signal_error('file-in-usr-local')
                files_found['usr_local'] = 1
            if x.endswith('.rej') or x.endswith('.orig'):
                self.signal_error('failed-diff', [x[1:]])
            if re.search(r'\/usr\/share\/doc.*\/[Ii][Nn][Ss][Tt][Aa][Ll]' +\
                '[Ll](\.gz)?$', x) and not files_found['install'] and \
                x.find('examples') == -1:
                self.signal_error('upstream-install-doc', [x[1:]])
                files_found['install'] = 1
            if x.find('.cvsignore') != -1 and not files_found['cvsignore']:
                self.signal_error('cvsignore-in-package')
                files_found['cvsignore'] = 1
            if path == '/usr/share' and not files_found['usr_share']:
                # If the path is /usr/share, keep has to be the file.
                self.signal_error('file-directly-in-u-s', [x[1:]])
                files_found['usr_share'] = 1
            if path in ('/bin', '/sbin', '/usr/bin', '/usr/sbin', \
                '/usr/X11R6/bin', '/usr/games'):
                if cur_file_perm != '0755' and not os.path.islink(x):
                    self.signal_error('incorrect-file-perms', [x[1:], \
                        cur_file_perm])
            if re.match(r'^\.#.*[0-9\.]{3}', keep) and not \
                files_found['cvs_bu']:
                self.signal_error('cvs-bu-in-pkg', [x[1:]])
            if path == '/etc/init.d':
                if cur_file_perm != '0755':
                    self.signal_error('bad-perms-for-initd', [x[1:], \
                        cur_file_perm])
            if path in ('/etc/rc.d', '/etc/rc.boot'):
                self.signal_error('package-install-bad-dir', [path])
            if path == '/usr/X11R6/lib/X11/app-defaults' and not \
                files_found['old-a-d']:
                self.signal_error('pkg-has-old-app-defaults', [x[1:]])
            license_re = re.compile(r'(copying|licen[cs]e)', re.IGNORECASE)
            if re.search(license_re, keep):
                throw, ext = os.path.splitext(x[1:])
                if ext not in ('.html', '.el', '.xpm'):
                    self.signal_error('extra-license-file', [x[1:]])
            if common.control.has_key('architecture'):
                if x.startswith('./usr/lib') and \
                    common.control['architecture'] == 'all' and not \
                    files_found['arch_all_lib'] and not \
                    self.usr_lib_exceptions(x):
                    files_found['arch_all_lib'] = 1
                    self.signal_error('usr-lib-in-arch-all', [x[1:]])
            if path in ('/usr/doc/' + self.pkg_name, '/usr/share/doc/' + \
                self.pkg_name):
                zero_size = 0
                if common.output['file'][x].find('compressed') != -1:
                    tmp_zcat = commands.getstatusoutput('zcat %s' % x)[1]
                    if not len(tmp_zcat):
                        zero_size = 1
                else:
                    if not os.path.getsize(x):
                        zero_size = 1
                if zero_size:
                    self.signal_error('zero-length-file', [x[1:]])
        for x in common.output['file'].keys():
            throw, keep = os.path.split(x[1:])
            if x.find('copyright') != -1 and \
                common.output['file'][x].find('compressed') != -1:
                self.signal_error('compressed-copyright')
            execute_bit = 0
            for i in common.output['perms'][x][1][1:]:
                if int(i) % 2:
                    execute_bit += 1
#             if execute_bit:
#                 if not x in common.output['elf'] and \
#                     common.output['file'][x].find('script') == -1 and not \
#                     os.path.islink(x):
#                     self.signal_error('exec-not-elf-or-script', [x[1:], \
#                         common.output['perms'][x][1]])
            if throw.startswith('/usr/lib') and \
                re.search(r'image (data|text)', common.output['file'][x]):
                self.signal_error('image-in-usr-lib', [x[1:]])
            scripts_look = {'dash': [], 'bash': []}
        for x in common.output['file'].keys():
            if common.output['file'][x].startswith('Bourne shell script'):
                scripts_look['dash'].append(x)
            elif common.output['file'][x].startswith('Bourne-Again shell'):
                scripts_look['bash'].append(x)
        dprint("Scripts to check: %s." % scripts_look, 2)
        for x in scripts_look.keys():
            for y in scripts_look[x]:
                parser_output = commands.getstatusoutput('%s -n %s </dev/null' % \
                    (x, y))[1]
                if parser_output:
                    self.signal_error('interp-minus-n-fails', [y, x])
                execute_bit = 0
                for z in common.output['perms'][y][1]:
                    if int(z) % 2:
                        execute_bit += 1
                if not execute_bit and (y.find('/examples') == -1 or not \
                    y.endswith('.ex')):
                    self.signal_error('script-not-executable', [y])

    def check_source_2(self):
        try:
            f = open(self.pkg_dir[0] + '/debian/rules')
        except IOError, e:
            dprint(_("Failed to open debian/rules: %s.") % e)
            f = 0
        if f:
            k = f.readline()[:-1]
            f.close()
            if k.find('/usr/bin/make -f') == -1:
                self.signal_error('debian-rules-not-makefile')
            if k.endswith(' '):
                self.signal_error('debian-rules-hashbang-space')
        if common.control[0].has_key('essential'):
            self.signal_error('source-has-essential')
        binary = {'dep': 0, 'indep': 0}
        for x in common.control[1:]:
            if x.has_key('architecture'):
                if x['architecture'] == 'all':
                    binary['indep']+=1
                else:
                    binary['dep']+=1
        if common.control[0].has_key('build-depends') and not binary['dep']:
            self.signal_error('build-dep-with-no-dep-pkgs')
        if common.control[0].has_key('build-depends-indep') and not \
            binary['indep']:
            self.signal_error('build-dep-indep-with-no-all')
        config_to_check = []
        if os.path.exists(self.pkg_dir[0] + '/config.guess'):
            config_to_check.append('config.guess')
        if os.path.exists(self.pkg_dir[0] + '/config.sub'):
            config_to_check.append('config.sub')
        for x in config_to_check:
            timestamp = 0
            f = open('%s/%s' % (self.pkg_dir[0], x))
            k = f.readline()
            while k != '':
                if k.startswith('timestamp'):
                    timestamp = k.split("='")[1].split('-')[0]
                    dprint(_("Setting timestamp of %s to %s.") % \
                        (x, timestamp), 2)
                k = f.readline()
            if int(timestamp) < 2002:
                self.signal_error('config-too-old', [x])
    def usr_lib_exceptions(self, path):
        exceptions = ('menu', 'python', 'emacsen-common', 'base-config', \
            'dpkg', 'sgml', 'site-python', 'debian-test', 'games', 'cgi-bin')
        tmp_check = 0
        for x in exceptions:
            if path.startswith('./usr/lib/' + x):
                tmp_check = 1
        return tmp_check

checks.register(FilesCheck)

