import re
from linda import common, checks

class ExampleFilesCheck(checks.LindaChecker):
    'See if a package contains any example or unneeded files.'
    def check_source_2(self):
         for x in self.pkg_dir:
            file_list = os.listdir('./' + x + '/debian')
            for y in file_list:
                if re.search(r'(ex\.|/.ex)', y):
                    self.signal_error('example-files')
                elif y.find('debian/files') != -1:
                    self.signal_error('debian-files-found')
                elif re.search(r'(config\.status|config\.cache)', y):
                    self.signal_error('autoconf-generated-files')

checks.register(ExampleFilesCheck)

