import commands
from linda import checks

class DpkgCheck(checks.LindaChecker):
    'Checks that relate to dpkg, or features of it.'
    def check_binary_1(self):
        ar_output = commands.getstatusoutput('ar t %s' % self.file)[1].\
            split('\n')
        for x in ar_output:
            if x in ('data.tar', 'data.tar.bz2'):
                self.signal_error('newer-feature-than-allowed')
        
checks.register(DpkgCheck)
