import re, commands
from linda import checks, common

class DocumentationCheck(checks.LindaChecker):
    'Checks relating to manual and info pages.'
    def check_binary_2(self):
        os.chdir('./unpacked')
        man_files = []
        bin_files = []
        for x in common.files:
            path, throw = os.path.split(x[1:])
            if path in ('/bin', '/sbin', '/usr/bin', '/usr/sbin', \
                '/usr/X11R6/bin', '/usr/games'):
                bin_files.append(x)
            elif re.search(r'/usr/(share/|X11R6/)?man/', x):
                throw, ext = os.path.splitext(x)
                if ext not in ('.html', '.txt'):
                    man_files.append(x)
        dprint(_("Before: Bin: %s") % bin_files, 2)
        dprint(_("Before: Man: %s") % man_files, 2)
        for x in man_files:
            throw, keep = os.path.split(x)
            if x.find('usr/man') != -1:
                self.signal_error('manual-in-usr-man', [keep])
            if not keep.endswith('.gz'):
                self.signal_error('manual-not-compressed', [keep])
            if os.path.islink(x):
                if os.readlink(x).find('undocumented.7') != -1:
                    if keep[-3:] == '.gz':
                        keep = keep[:-3]
                    self.signal_error('link-to-undocumented', [keep])
            exec_set = 0
            if os.path.isfile(x):
                for z in common.output['perms'][x][1]:
                    if int(z) % 2:
                        exec_set += 1
            if exec_set and not os.path.islink(x):
                self.signal_error('executable-manual-page', [x[1:]])
            if common.output['file'][x].find('max compression') == -1 and \
                common.output['file'][x].find('/man/') != -1 and not \
                os.path.islink(x):
                self.signal_error('manual-not-max-compression', \
                    [x[1:]])
            if not common.output['file'][x].find('gzip compressed') != 1 and \
                x.find('/man') != -1:
                self.signal_error('manual-not-using-gzip', [x])
            groff_cmd = 'groff -T ascii -z'
            if x.endswith('.gz'):
                exitstat = commands.getstatusoutput("zcat %s | %s" % \
                    (x, groff_cmd))[0]
            else:
                exitstat = commands.getstatusoutput('%s %s' % (groff_cmd, \
                    x))[0]
            if exitstat:
                self.signal_error('groff-failed-on-manpage', [x[1:]])
        for x in range(len(bin_files)):
            throw, keep = os.path.split(bin_files[x][1:])
            bin_files[x] = self.kill_extensions(keep)
        for x in range(len(man_files)):
            throw, keep = os.path.split(man_files[x][1:])
            if man_files[x][-3:] == '.gz':
                keep = keep[:keep.rfind('.', 0, -4)]
                man_files[x] = keep
            man_files[x] = self.kill_extensions(keep)
        dprint(_("After: Bin: %s") % bin_files, 2)
        dprint(_("After: Man: %s") % man_files, 2)
        for x in bin_files:
            if x not in man_files:
                self.signal_error('no-manual-for-binary', [x])
    def kill_extensions(self, filename):
        file, throw = os.path.splitext(filename)
        if throw in ('.pl', '.py', '.sh') + tuple(['.' + str(x) for x in \
            range(1, 10)]):
            return file
        else:
            return filename

checks.register(DocumentationCheck)

