import re, commands
from linda import common, checks

class DebhelperCheck(checks.LindaChecker):
    'Check a packages use of debhelper.'
    def check_source_2(self):
        build_deps_on_dh = 0
        maint_to_check = ['preinst', 'postinst', 'prerm', 'postrm']
        dh_tag = {'preinst': 0, 'postinst': 0, 'prerm': 0, 'postrm': 0}
        dh_usedin = {'preinst': 0, 'postinst': 0, 'prerm': 0, \
            'postrm': 0}
        build_deps_on_dh = 0
        for x in ('build-depends', 'build-depends-indep'):
            if common.control[0].has_key(x):
                if common.control[0][x].has_key('debhelper') or \
                    common.control[0][x].has_key('cdbs'):
                    build_deps_on_dh = 1
        usage = {'dh': 0, 'dh_tv': 0, 'local_dh': 0, 'dh_compat': 0}
        for x in self.pkg_dir:
            f = open ('%s/debian/rules' % x)
            for l in f.xreadlines():
                if l.find('export DH_COMPAT=') != -1:
                    # So I can parse out compat level as well.
                    usage['dh'] = 1
                    tmp_dh_compat = l.split('=')[1]
                    if tmp_dh_compat.endswith('\n'):
                        tmp_dh_compat = tmp_dh_compat[:-1]
                    usage['dh_compat'] = int(tmp_dh_compat)
            f.close()
            mf_commands = commands.getstatusoutput('cd %s; ' % x +\
                'make -nf debian/rules binary')
            binary_target = filter(filter_lines, mf_commands[1].split('\n'))
            dprint(_("Binary target: %s") % binary_target, 2)
            if 'dh_installdefoma' in binary_target or 'dh_installinit' in \
                binary_target or 'dh_installwm' in binary_target:
                for i in ('prerm', 'postrm', 'postinst'):
                    dh_usedin[i] = 1
            if 'dh_installdocs' in binary_target or 'dh_installemacsen' in \
                binary_target or 'dh_installinfo' in binary_target:
                for i in ('prerm', 'postinst'):
                    dh_usedin[i] = 1
            if 'dh_installmenu' in binary_target or 'dh_installmime' in \
                binary_target or 'dh_installmodules' in binary_target or \
                'dh_installxfonts' in binary_target:
                for i in ('postrm', 'postinst'):
                    dh_usedin[i] = 1
            for y in binary_target:
                if y.startswith('dh_'):
                    usage['dh'] = 1
                elif y.startswith('./dh_'):
                    usage['local_dh'] = 1
            if 'dh_testversion' in binary_target:
                usage['dh_tv'] = 1
            if not usage['dh_compat']:
                try:
                    f = open(x + '/debian/compat')
                    usage['dh_compat'] = int(f.readline()[:-1])
                    f.close()
                except IOError, e: 
                    dprint(_("Can't open debian/compat: %s.") % e)
                except ValueError, e:
                    dprint(_("Can't convert dh_compat to int: %s.") % e)
            for y in maint_to_check:
                try:
                    f = open(x + '/debian/' + y)
                    for m in f.xreadlines():
                        if m.find('#DEBHELPER#') != -1:
                            dh_tag[y] = 1
                    f.close()
                except IOError, e:
                    dprint(_("%s can't be opened: %s.") % (y, e))
                    dh_tag[y] = -1
        debhelper_major = 0
        for x in ('build-depends', 'build-depends-indep'):
            if common.control[0].has_key(x):
                if common.control[0][x].has_key('debhelper') and not \
                    debhelper_major:
                    if not common.control[0][x]['debhelper']:
                        debhelper_major = 1
                    else:
                        debhelper_major = \
                            int(common.control[0][x]['debhelper'][1].\
                                split('.')[0])
        if common.control[0].has_key('build-depends') or \
            common.control[0].has_key('build-depends-indep'):
            if usage['dh_compat'] > debhelper_major and not \
                usage['local_dh'] and usage['dh_compat'] > 1:
                self.signal_error('dh-compat-greater-than-depends')
        if build_deps_on_dh and not usage['dh']:
            self.signal_error('no-debhelper-but-build-dep')
        elif not build_deps_on_dh and usage['dh'] and not usage['local_dh']:
            self.signal_error('missing-build-dep-on-dh')
        if usage['dh_tv']:
            self.signal_error('uses-dh-testversion')
        for y in maint_to_check:
            if dh_usedin[y] and not dh_tag[y]:
                self.signal_error('maint-uses-dh-no-tag', [y])    

def filter_lines(x):
    if x.startswith('#') or x.startswith('make['):
        return 0
    else:
        return 1

checks.register(DebhelperCheck)

