import re
from linda import checks, common, dpkgver

class DebconfCheck(checks.LindaChecker):
    'Check the debconf-y things a package is doing.'
    def check_binary_1(self):
        try:
            f = open('./control/templates')
        except IOError, e:
            f = 0
            dprint(_("Can not open templates file: %s.") % e)
            if os.path.exists('./control/config'):
                # This means templates doesn't exist, but config does.
                self.signal_error('config-no-templates')
        debconf_parse = [{}]
        x = 0
        if f:
            for k in f.xreadlines():
                if k == '\n':
                    debconf_parse.append({})
                    x += 1
                elif re.match(r'description', k, re.IGNORECASE):
                    cur_desc = k[:-1].split(': ')
                    if len(cur_desc) == 1:
                        cur_desc.append('')
                    debconf_parse[x][cur_desc[0]] = cur_desc[1]
                elif k.startswith(' ') or k == '.\n':
                    debconf_parse[x][cur_desc[0]] += k
                elif k.find(': ') != -1:
                    data = k[:-1].split(': ')
                    debconf_parse[x][data[0]] = ''
                    for y in data[1:]:
                        debconf_parse[x][data[0]] += y
            f.close()
        for x in debconf_parse:
            # This variable can be empty, so we should test for that.
            if not x:
                continue
            if not x.has_key('Type'):
                self.signal_error('debconf-no-type')
            else:
                if x['Type'] not in ('string', 'boolean', 'select', \
                    'multiselect', 'note', 'text', 'password'):
                    self.signal_error('unknown-debconf-type', [x['Type'][:-1]])
                if x['Type'].find('select') != -1 and not \
                    x.has_key('Choices'):
                    self.signal_error('debconf-select-without-choices')
                if x['Type'] == 'multiselect':
                    if common.control['depends'].has_key('debconf'):
                        if common.control['depends']['debconf'][0] == '>=' or \
                        common.control['depends']['debconf'][0] == '>>':
                            ver_a = dpkgver.DpkgVersion(common.control\
                                ['depends']['debconf'][1])
                            if ver_a < '0.2.26':
                                self.signal_error('unsufficent-version-multi')
            if not x.has_key('Template'):
                self.signal_error('debconf-no-template')
            for y in x.keys():
                if y not in ('Template', 'Type') and not \
                    (y.startswith('Description') or y.startswith('Choices') \
                    or y.startswith('Default')):
                    self.signal_error('unknown-field-templates', [y])
        postrm_purge_counter = 0
        confmodule = {'postinst': 0, 'preinst': 0, 'postrm': 0, 'prerm': 0, \
            'config': 0}
        obsol_confmodule = {'postinst': 0, 'preinst': 0, 'postrm': 0, \
            'prerm': 0, 'config': 0}
        isdefault = {'postinst': 0, 'preinst': 0, 'postrm': 0, 'prerm': 0, \
            'config': 0}
        for i in confmodule.keys():
            try:
                f = open('./control/' + i)
            except IOError, e:
                dprint(_("Can't open %s: %s.") % (i, e))
                f = 0
            if f:
                for k in f.xreadlines():
                    if re.search(r'(\s+)?#', k):
                        continue
                    if k.find('/usr/share/debconf/confmodule.sh') != -1 or \
                        k.find('DebConf::Client::ConfModule') != -1:
                        obsol_confmodule[i] = 1
                    if (k.find('db_input') != -1 or k.find('input(') != -1) \
                        and i == 'postinst':
                        self.signal_error('postinst-db-input')
                    if k.find('isdefault') != -1 and not isdefault[i]:
                        isdefault[i] = 1
                        self.signal_error('debconf-isdefault-deprecated')
                    if (k.find('db_purge') != -1 or k.find('purge(') != -1) \
                        and i == 'postrm':
                        postrm_purge_counter += 1
                    if (k.find('db_seen') != -1 or k.find('seen(') != -1) and \
                        dpkgver.SimpleCompare(common.control['depends']\
                        ['debconf'][1], '0.5') == -1:
                        self.signal_error('seen-not-recent')
                    if k.find('/usr/share/debconf/confmodule') != -1 or \
                        k.find('Debconf::Client::ConfModule') != -1:
                        confmodule[i] = 1
                f.close()
                if common.control.has_key('depends'):
                    if i == 'postrm' and postrm_purge_counter == 0 and \
                        common.control['depends'].has_key('debconf'):
                        self.signal_error('debconf-postrm-fails-purge')
                if i == 'config' and not confmodule['config'] and not \
                    obsol_confmodule['config']:
                    self.signal_error('config-not-load-confmodule')
                if common.control.has_key('pre-depends'):
                    if i == 'preinst' and confmodule['preinst'] and not \
                        common.control['pre-depends'].has_key('debconf'):
                        self.signal_error('missing-pre-depends-debconf')
        for x in obsol_confmodule.keys():
            if obsol_confmodule[x]:
                self.signal_error('obsolete-confmodule', [x])

checks.register(DebconfCheck)

