import re, commands
from linda import checks, common

class ControlFilesCheck(checks.LindaChecker):
    'Check the maintainer scripts of a package.'
    def check_binary_1(self):
        os.chdir('./control')
        exec_control = ('postinst', 'prerm', 'postrm', 'preinst', \
            'config')
        norm_control = ('control', 'md5sums', 'conffiles', 'templates', \
            'shlibs')
        control_files = exec_control + norm_control
        for k in common.control_info.keys():
            if k not in control_files:
                self.signal_error('unknown-control-file', [k])
            if common.control_info[k][0] != 'root/root':
                self.signal_error('incorrect-ownership-control', [k])
            if (k in exec_control and common.control_info[k][1] != '0755') or \
                (k in norm_control and common.control_info[k][1] != '0644'):
                self.signal_error('incorrect-control-perms', [k])
        for x in exec_control:
            if not os.path.exists(x):
                continue
            try:
                f = open(x)
                k = f.readline()[:-1]
                f.close()
            except IOError, e:
                dprint(_("Failed to read shebang line: %s.") % e)
                k = ''
            parser_call = k.split('/')[-1].split(' ')[0]
            cmd = ''
            parser_output = ''
            if parser_call in ('sh', 'ash', 'dash'):
                cmd = 'dash'
            if parser_call == 'bash':
                cmd = 'bash'
            if cmd:
                parser_output = commands.getstatusoutput('%s -n %s' % \
                    (cmd, x))[1]
            if parser_output:
                self.signal_error('possible-maint-error', [x, cmd])
            try:
                f = open(x)
            except IOError, e:
                f = 0
            if f:
                updatercd_calls = {'./postrm': 0, './postinst': 0}
                for y in updatercd_calls.keys():
                    for z in f.xreadlines():
                        if z.find('update-rc.d') != -1 and \
                            z.find('remove') == -1:
                            updatercd_calls[y] += 1
                    if updatercd_calls[y] > 1:
                        self.signal_error('multiple-update-rc.d', \
                            [x[2:], updatercd_calls[y]])
        conffiles = {}
        if os.path.exists('conffiles'):
            f = open('conffiles')
            for x in f.xreadlines():
                y = x.strip()
                if conffiles.has_key(y):
                    conffiles[y] += 1
                else:
                    conffiles[y] = 1
        dprint(_("Conffiles parsed in: %s.") % conffiles, 2)
        for x in conffiles.keys():
            if conffiles[x] >= 2:
                self.signal_error('duplicate-conffile', [x, conffiles[x]])
        for x in exec_control:
            things_found = {'killall': 0, 'mknod': 0, 'dpkgpa': 0, 'sr': 0, \
                'ua': 0, 'tmp': 0, 'binshe': 0, 'netbasestuff': 0, 'inetd': 0}
            try:
                f = open(x)
            except IOError:
                continue
            else:
                for k in f.xreadlines():
                    if re.search(r'(\s+)?#', k) or k.find('echo') != -1 or \
                        k.find('printf') != -1:
                        continue
                    if k.startswith('#!/bin/sh -e'):
                        things_found['binshe'] = 1
                    if k.find('killall ') != -1:
                        things_found['killall'] = 1
                    elif k.find('mknod ') != -1:
                        things_found['mknod'] = 1
                    elif k.find('dpkg --print-architecture') != -1:
                        things_found['dpkgpa'] = 1
                    elif k.find('suidregister ') != -1:
                        things_found['sr'] = 1
                    if x == './postrm' and k.find('update-alternatives ' +\
                        '--remove') != -1:
                        things_found['ua'] = 1
                    if re.search('^\s*(/var)?/tmp/\w', k) and \
                        k.find('mktemp') == k.find('tempfile') == \
                        k.find('mkdir') == -1:
                        things_found['tmp'] = 1
                    if k.find('/etc/services') != -1 or \
                        k.find('/etc/protocols') != -1 or k.find('/etc/rpc') \
                        != -1:
                        things_found['netbasestuff'] = 1
                    if re.search(r'(\>|ed).?/etc/inetd.conf', k):
                        things_found['inetd'] = 1
            if things_found['killall']:
                self.signal_error('killall-in-maint', [x])
            if things_found['mknod']:
                self.signal_error('mknod-in-maint', [x])
            if things_found['dpkgpa']:
                self.signal_error('dpkg-pa-in-maint', [x])
            if things_found['sr']:
                self.signal_error('suid-in-maint', [x])
            if things_found['ua']:
                self.signal_error('update-alt-in-postrm')
            if things_found['tmp']:
                self.signal_error('insecure-tmp-handling', [x])
            if things_found['binshe']:
                self.signal_error('bin-sh-e-in-maint', [x])
            if things_found['netbasestuff']:
                self.signal_error('netbase-managed-in-maint', [x])
            if things_found['inetd']:
                self.signal_error('inetd-in-maint', [x])

checks.register(ControlFilesCheck)

