import re, types, operator
from linda import common, checks

class ControlCheck(checks.LindaChecker):
    'Perform general checks of the control file.'
    def check_binary_1(self):
        if common.control.has_key('package'):
            upper = reduce(operator.add, [x.isupper() for x in \
                common.control['package']])
            if upper:
                self.signal_error('upper-in-package')
            if common.control['package'].endswith('-perl'):
                if common.control['section'] == 'interpreters':
                    self.signal_error('perl-pkg-should-be-sct-perl')
            if common.control['package'].startswith('python-'):
                if common.control['section'] == 'interpreters':
                    self.signal_error('python-pkg-should-be-sct-py')
        if common.control.has_key('priority'): 
            if aps_not_valid('priority', common.control['priority']):
                self.signal_error('unknown-priority', \
                    [common.control['priority']])
        if common.control.has_key('build-depends'):
            found_auto = 0
            for x in common.control['build-depends'].keys():
                if x == 'autoconf' or x.startswith('automake'):
                    found_auto = 1
            if found_auto:
                self.signal_error('package-b-d-on-autostar')
        if common.control.has_key('section'):
            section = ''
            if common.control['section'].find('/') != -1:
                sect_split = common.control['section'].split('/')
                section = sect_split[1]
                if sect_split[0] == 'non-us':
                    self.signal_error('spelling-non-us')
                elif sect_split[0] not in ('contrib', 'non-free', 'non-US'):
                    self.signal_error('unknown-component', [sect_split[0]])
            else:
                section = common.control['section']
            if aps_not_valid('section', section):
                self.signal_error('unknown-section', [section])
        if common.control.has_key('maintainer'):
            if not common.control['maintainer']:
                self.signal_error('empty-maintainer')
            else:
                if common.control['maintainer'].find('<') == -1:
                    self.signal_error('no-maintainer-email')
                else:
                    maint_mail = common.control['maintainer']\
                        [common.control['maintainer'].find('<'):\
                        common.control['maintainer'].find('>')]
                    if not re.search(r"[a-zA-Z0-9']{1,}@.*\.", maint_mail):
                        self.signal_error('malformed-maint-mail-addr')
        else:
            self.signal_error('no-maintainer')
        if common.control.has_key('essential'):
            if common.control['essential'].lower() == 'no':
                self.signal_error('essential-no-redundant')
            if common.control['essential'].lower() not in ('no', 'yes'):
                self.signal_error('essential-not-yes-or-no', \
                    [common.control['essential']])
            if aps_not_valid('essential', self.pkg_name):
                self.signal_error('new-essential-package')
        if common.control.has_key('description'):
            if common.control['description'].startswith(self.pkg_name):
                self.signal_error('desc-starts-with-package')
            if common.control['description'].find('  ') != -1:
                self.signal_error('multiple-spaces-in-desc')
        if common.control.has_key('depends'):
            for x in common.control['depends'].keys():
                if not aps_not_valid('essential', x) and not \
                    common.control['depends'][x]:
                    self.signal_error('no-version-dep-on-essential', [x])
                if x == self.pkg_name:
                    self.signal_error('pkg-depends-on-self')
        if common.control.has_key('provides'):
            for x in common.control['provides'].keys():
                if len(common.control['provides'][x]) >= 2:
                    self.signal_error('versioned-provides', [x])
        if not common.control.has_key('package'):
            self.signal_error('no-package-line')
        if not common.control.has_key('priority'):
            self.signal_error('no-priority-line')
        if not common.control.has_key('version'):
            self.signal_error('no-version-line')
        else:
            if not self.isnative:
                deb_rev = common.control['version'].split('-')[-1]
                if deb_rev == '0':
                    self.signal_error('deb-revision-zero')
        if not common.control.has_key('description'):
            self.signal_error('no-description')
        else:
            if len(common.control['description']) > 80:
                self.signal_error('description-too-long')
            if common.control['description'].endswith('.'):
                self.signal_error('description-ends-with-fullstop')
            if common.control.has_key('ex-desc'):
                if common.control['description'].find('\t') != -1 or \
                    common.control['ex-desc'].find('\t') != -1:
                    self.signal_error('tab-in-desc')
                if common.control['ex-desc'].find\
                    (common.control['description']) != -1:
                    self.signal_error('ex-desc-contains-desc')
        obsel_count = 0
        for x in ('revision', 'package-revision', 'package_revision', \
            'recommended', 'optional', 'class'):
            if common.control.has_key(x):
                obsel_count += 1
        if obsel_count:
            self.signal_error('obsolete-field-in-control')

    def check_source_2(self):
        if common.control[0].has_key('build-depends'):
            for x in common.control[0]['build-depends'].keys():
                if len(common.control[0]['build-depends'][x]) > 0:
                    if type(common.control[0]['build-depends'][x][-1]) == \
                        types.ListType:
                        for y in common.control[0]['build-depends'][x][-1]:
                            if aps_not_valid('arch', y):
                                self.signal_error('invalid-arch-in-b-d', \
                                    [y])
        if common.control[0].has_key('essential'):
            self.signal_error('essential-field-in-source')
        if not common.control[0].has_key('source'):
            self.signal_error('no-source-field-in-source')
        else:
            for x in common.control[0]['source']:
                if (ord(x) < 48 and ord(x) > 122) and ord(x) not in (43, 45, \
                    46):
                    self.signal_error('bad-source-field')
            if self.pkg_name != common.control[0]['source']:
                self.signal_error('source-not-like-package')
        for x in range(len(common.control)):
            for y in common.control[x].keys():
                for z in y:
                    if ord(z) <= 32 or ord(z) > 126:
                        self.signal_error('char-forbidden-rfc822', [z])
    
checks.register(ControlCheck)

