from linda import common, checks
from linda.common import iterate_dir

class ConfigFileCheck(checks.LindaChecker):
    'Checks relating to the conffiles file.'
    def check_binary_2(self):
        conffiles = []
        try:
            f = open('./control/conffiles')
            conffiles = f.readlines()
            f.close()
        except IOError, e:
            dprint(_("Failure opening conffiles: %s.") % e)
        for x in range(len(conffiles)):
            conffiles[x] = conffiles[x][:-1]
            (j, l) = os.path.split(conffiles[x])
            if conffiles[x].find('/etc') == -1:
                self.signal_error('non-etc-conffile', [l])
            if not conffiles[x].startswith('/'):
                self.signal_error('relative-conffile', [l])
        os.chdir('./unpacked')
        conf_files = iterate_dir('./etc')
        for x in conf_files:
            if x[1:] not in conffiles:
                (j, l) = os.path.split(x)
                self.signal_error('etc-conffile', [l, j[1:]])

checks.register(ConfigFileCheck)

