import md5, string
from linda import checks, common

class ChangesCheck(checks.LindaChecker):
    def check_changes_1(self):
        try:
            f = open(self.file)
        except IOError, e:
            dprint(_("Can't open the changes file: %s.") % e)
            f = 0
        if f:
            k = f.readline()
            while not k.startswith('Files: '):
                if k.find('Distribution: ') != -1:
                    for x in k[:-1].split(': ')[-1].split(' '):
                        if x in ('woody-proposed-updates', \
                            'testing-proposed-updates'):
                            self.signal_error('obselete-dist', [x])
                            continue
                        if x not in ('oldstable-security', 'stable', \
                            'stable-security', 'testing', 'testing-security', \
                            'unstable', 'experimental'):
                            self.signal_error('incorrect-distribution', [x])
                k = f.readline()
            file_lines = []
            for k in f.xreadlines():
                tmp = k.split(' ')
                if len(tmp) == 6:
                    file_lines.append(k[:-1])
                if k == '\n' or k == '':
                    break
                k = f.readline()
            f.close()
            path, throw = os.path.split(self.file)
            hexStr = string.hexdigits
            md5sum = []
            for x in file_lines:
                try:
                    f = open(path + '/' + x.split(' ')[-1])
                except EnvironmentError, e:
                    dprint(_("Can't calculate md5 for %s: %s.") % \
                        (x.split(' ')[-1], e))
                    f = 0
                if f:
                    check_obj = md5.new()
                    for x in f.xreadlines():
                        check_obj.update(x)
                    f.close()
                    checksum = ''
                    for c in check_obj.digest():
                        checksum = checksum + hexStr[(ord(c) >> 4) & 0xF] + \
                            hexStr[ord(c) & 0xF]
                    md5sum.append(checksum)
                else:
                    md5sum.append(0)
            for x in range(len(file_lines)):
                cur_file_line = file_lines[x].split(' ')
                if os.path.exists(path + '/' + cur_file_line[-1]):
                    cur_file_size = os.path.getsize(path + '/' + \
                        cur_file_line[-1])
                else:
                    cur_file_size = 0
                if md5sum[x] == 0 or cur_file_size == 0:
                    dprint(_("Md5sum or file size for %s is zero.") % \
                        cur_file_line[-1])
                    continue
                else:
                    if cur_file_line[1] != md5sum[x]:
                        self.signal_error('md5sum-mismatch', \
                            [cur_file_line[-1]])
                    if int(cur_file_line[2]) != cur_file_size:
                        self.signal_error('file-size-mismatch', \
                            [cur_file_line[-1]])
                section = ''
                if cur_file_line[3].find('/') != -1:
                    # Should be either contrib or non-free
                    split_line = cur_file_line[3].split('/')
                    section = split_line[1]
                    if split_line[0] not in ('contrib', 'non-free', 'non-US'):
                        self.signal_error('unknown-component-changes', \
                            [split_line[0]])
                else:
                    section = cur_file_line[3]
                if aps_not_valid('section', section) and section != 'byhand':
                    self.signal_error('unknown-section-changes', \
                        [cur_file_line[-1], section])

checks.register(ChangesCheck)

