import re, gzip
from linda import checks, common, dpkgver

class ChangelogCheck(checks.LindaChecker):
    'Checks to do with the Debian and upstream changelog.'
    def check_binary_2(self):
        usd_symlink = 0
        changelogs = {}
        found = {'upstream': 0}
        f = {'file': 0, 'name': ''}
        for x in common.output['file'].keys():
            if re.search(r'\/doc.*changelog', x, re.IGNORECASE):
                tmp_name = 'unpacked' + x[1:]
                tmp_path, tmp_file = os.path.split(x[1:])
                changelogs[x] = {'size': int(os.path.getsize(tmp_name)), \
                    'link': os.path.islink(tmp_name), 'path': tmp_path, \
                    'file': tmp_file}
        dprint(_("Changelogs found: %s.") % changelogs, 2)
        if os.path.islink('unpacked/usr/share/doc/' + self.pkg_name):
            usd_symlink = 1
            other_pkg = os.readlink('unpacked/usr/share/doc/' + self.pkg_name)
            if common.control.has_key('depends'):
                if not common.control['depends'].has_key(other_pkg) and \
                    aps_not_valid('essential', other_pkg):
                    self.signal_error('usd-symlink-no-depends')
        for x in changelogs.keys():
            if changelogs[x]['size'] > 4096 and not changelogs[x]['link'] \
                and not x.endswith('.html'):
                if common.output['file'][x].find('gzip compressed') == -1:
                    self.signal_error('non-compressed-changelog', [x[1:]])
                if common.output['file'][x].find('max compression') == -1 \
                    and common.output['file'][x].find('gzip compressed') != -1:
                    self.signal_error('not-max-compression-changelog', [x[1:]])
            if changelogs[x]['path'].startswith('/usr/doc'):
                self.signal_error('changelog-usr-doc', [x[1:]])
            if changelogs[x]['file'].find('html') != -1:
                if os.path.splitext(x[1:])[0] not in changelogs.keys():
                    self.signal_error('html-only-changelog', [x[1:]])
            if changelogs[x]['path'] == '/usr/doc/' + self.pkg_name or \
                changelogs[x]['path'] == '/usr/share/doc/' + self.pkg_name:
                if self.isnative:
                    if changelogs[x]['file'].startswith('changelog.Debian'):
                        self.signal_error('wrong-changelog-name')
                    if changelogs[x]['file'].startswith('changelog'):
                        if changelogs[x]['size'] > 4096 and \
                            common.output['file'][x].find('gzip compressed') \
                            == -1:
                            self.signal_error('native-changelog-not-' +\
                                'compressed')
                        f['name'] = x[1:]
                        dprint(_("Setting changelog to: %s") % x[1:], 2)
                        if not os.path.islink('unpacked' + x[1:]):
                            if common.output['file'][x].find('gzip ' +
                                'compressed') != -1:
                                f['file'] = gzip.GzipFile('unpacked' + x[1:])
                            else:
                                f['file'] = open('unpacked' + x[1:])
                else:
                    if changelogs[x]['file'].startswith('changelog') and \
                        changelogs[x]['file'].find('Debian') == -1:
                        found['upstream'] = 1
                    if changelogs[x]['file'].startswith('changelog.Debian'):
                        f['name'] = x[1:]
                        dprint(_("Setting changelog to: %s") % x[1:], 2)
                        if not os.path.islink('unpacked' + x[1:]):
                            if common.output['file'][x].find('gzip ' +
                                'compressed') != -1:
                                f['file'] = gzip.GzipFile('unpacked' + x[1:])
                            else:
                                f['file'] = open('unpacked' + x[1:])
        if not self.isnative:
            if not found['upstream'] and not usd_symlink:
                self.signal_error('no-upstream-changelog')
        if f['file']:
            dprint(_("Debian changelog: %s.") % f['file'], 2)
            k = f['file'].readline()
            while k != '':
                if k.startswith('add-log-mailing-address: '):
                    self.signal_error('emacs-settings-in-changelog', \
                        [f['name']])
                k = f['file'].readline()
            f['file'].close()
        else:
            if self.isnative:
                tmp_name = 'changelog'
            else:
                tmp_name = 'changelog.Debian'
            if not usd_symlink:
                self.signal_error('no-changelog', [tmp_name])
    
    def check_source_2(self):
        for x in self.pkg_dir:
            try:
                f = open(x + '/debian/changelog')
            except IOError, e:
                dprint(_("Can't open changelog: %s.") % e)
                f = 0
        all_ver = []
        if f:
            urgency = re.compile(r'^\w.*urgency=')
            for k in f.xreadlines():
                if urgency.match(k):
                    start, end = map(k.find, '()')
                    pos_ver = k[start+1:end]
                    all_ver.append(dpkgver.DpkgVersion(pos_ver))
                    if len(all_ver) == 2:
                        break
            f.close()
        if len(all_ver) == 2:
            if all_ver[0] < all_ver[1]:
                self.signal_error('next-ver-less-than-prev', [all_ver[0], \
                    all_ver[1]])

checks.register(ChangelogCheck)

