import re, commands
from linda import checks, common

class BinaryCheck(checks.LindaChecker):
    'Checks binary objects contained within a package.'
    def check_binary_2(self):
        depends_line = pre_dep_line = 0
        binary_exceptions = ('gcc-lib')
        if common.control.has_key('architecture'):
            arch = common.control['architecture']
        else:
            arch = 'none'
        os.chdir('./unpacked')
        dprint(_("Architecture: %s") % arch)
        for x in common.output['elf']:
            if x.startswith('./usr/share/doc'):
                self.signal_error('binary-in-usr-share-doc', [x[1:]])
        if aps_not_valid('arch', arch):
            self.signal_error('unknown-arch', [arch])
        if common.output['elf'] and arch == 'all':
            self.signal_error('pkg-should-be-arch-any')
        elif not common.output['elf'] and aps_not_valid('arch', arch):
            self.signal_error('pkg-should-be-arch-all')
        if common.output['elf'] and not \
            (common.control.has_key('depends') or \
            common.control.has_key('pre-depends')):
            self.signal_error('no-depends-line')
        for n in common.output['elf']:
            next_one = 0
            for x in binary_exceptions:
                if x.find(n) != -1:
                    next_one = 1
            if next_one: continue
            sonames = {}
            if common.output['ldd'][n].find('statically linked') != -1:
                continue
            for x in common.output['ldd'][n].split('\n'):
                if x.find('.so.') == -1: continue
                tmp_array = x[1:].split(' => ')[0].split('.so.')
                if tmp_array[0] == 'libc': continue
                if tmp_array[0].find('-') != -1 and \
                    tmp_array[0].find('libstdc++') != -1:
                    tmp_array[0] = tmp_array[0][:tmp_array[0].find('-')]
                if sonames.has_key(tmp_array[0]):
                    if sonames[tmp_array[0]] == tmp_array[1]:
                        # Same sover, drop it.
                        continue
                    dprint(_("Sonames during double: %s") % sonames, 2)
                    self.signal_error('double-shlib', [n[1:], \
                        sonames[tmp_array[0]], tmp_array[1], tmp_array[0]])
                else:
                    sonames[tmp_array[0]] = tmp_array[1]
            if n.startswith('./etc'):
                self.signal_error('binary-in-etc', [n[1:]])
            elif n.find('/usr/share') != -1:
                self.signal_error('arch-dep-in-usr-share')
            elif n.find('/usr/doc') != -1 or n.find('/usr/share/doc') != -1:
                self.signal_error('binary-in-doc-dir', [n[1:]])
            if common.output['objdump'][n].find('format not recognized') != -1:
                continue
            if common.output['objdump'][n].find('RPATH') != -1:
                rpath_str = common.output['objdump'][n]\
                    [common.output['objdump'][n].find('RPATH'):\
                    common.output['objdump'][n].find('\n', \
                    common.output['objdump'][n].find('RPATH'))]
                rpath_lst = re.split(' +', rpath_str)
                if rpath_lst[-1] != '':
                    self.signal_error('binary-rpath', [n[1:], \
                        rpath_lst[-1]])
            found = {'note': 0, 'comment': 0}
            if not (re.search(r'(dbg|debug)', n[1:]) or \
                re.search(r'(dbg|debug)', self.pkg_name)):
                if re.search(r'\s+\.note\s+', common.output['objdump'][n]):
                    found['note'] = 1
                if re.search(r'\s+\.comment\s+', common.output['objdump'][n]):
                    found['comment'] = 1
                if found['note'] and found['comment']:
                    self.signal_error('not-quite-stripped-binary', [n[1:]])
                elif found['note'] or found['comment']:
                    if found['note']: str = '.note'
                    if found['comment']: str = '.comment'
                    self.signal_error('binary-note', [n[1:], str])
            if common.output['objdump'][n].find('libc.so.5') != -1 and \
                n.find('/libc5-compat') == -1:
                self.signal_error('binary-libc5', [n[1:]])
            if common.output['objdump'][n].find('libc.so.6') != -1 and \
               n.find('/libc5-compat') != -1:
                self.signal_error('libc6-binary-in-libc5-dir', [n[1:]])
            if common.output['objdump'][n].find('libc.so') == -1 and not \
                re.search(r'(statically linked|LSB relocatable)', \
                common.output['file'][n]):
                self.signal_error('binary-libc6', [n[1:]])
            if common.output['file'][n].find('statically') != -1 and not \
                n.startswith('./boot') and n.find('.static') == -1:
                self.signal_error('static-binary', [n[1:]])
            if common.output['file'][n].find('not stripped') != -1 and \
                not (re.search(r'(dbg|debug)', self.pkg_name)):
                self.signal_error('unstripped-binary', [n[1:]])
            if common.output['file'][n].find(', stripped') != -1 and \
                re.search(r'(-|_)(dbg|debug|g)$', n):
                self.signal_error('stripped-binary-not', [n[1:]])
            if common.output['objdump'][n].find('Packed with UPX') != -1:
                self.signal_error('binary-upx', [n[1:]])
            if re.search(r'\.text.*__gmon_start__', \
                common.output['objdump'][n]) and arch != 'hppa':
                self.signal_error('binary-profiling', [n[1:]])
            if common.output['objdump'][n].find('NEEDED') == \
                common.output['file'][n].find('statically linked') == -1:
                self.signal_error('shared-binary', [n[1:]])

checks.register(BinaryCheck)

