/**
 * @file sappd_callbacks.c
 *
 * The shadow application library, wrapper-side callback implementations.
 * <p>
 * Copyright (C) 2005 Nokia Corporation
 *
 * @author Kuisma Salonen <kuisma.salonen@nokia.com>
 */


#include <memory.h>
#include <string.h>
#include <unistd.h>
#include <glib.h>
#include <libosso.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/un.h>
#include <gconf/gconf-client.h>

#include "shadowappd.h"

void sigchld_handler(int signal)
{
  g_main_loop_quit(main_cont->mainloop);

  if(main_cont->state != SAPPD_STATE_INACTIVE) {
    main_cont->state = SAPPD_STATE_ACTIVE;
  }

  if(main_cont->connstate == SAPPD_CONNSTATE_ACTIVE) {
    sappd_flush_socket(main_cont);
    if(main_cont->connstate == SAPPD_CONNSTATE_ACTIVE) {
      sappd_crashed = 1;
#ifdef SAPPD_DEBUG
      _sd_debugprint("so we crashed");
#endif
    }
  }
#ifdef SAPPD_DEBUG
  else {
    _sd_debugprint("clean SIGCHLD came in");
  }
#endif

  kill(main_cont->child_pid, SIGKILL);

  waitpid(main_cont->child_pid, NULL, 0);
}

void sappd_flush_socket(sapp_d_data *context)
{
  int rc;
  int i;

  while(1) {
    rc = recv(context->connection_sd, context->inbuf, 16, MSG_DONTWAIT);
    if(rc > 0) {
      for(i = 0; i < rc; i++) {
        context->realbuf[context->realbuflen] = context->inbuf[i];
        context->realbuflen++;
        if(context->inbuf[i] == '\n') {
          sappd_parse_realbuf(context);
          context->realbuflen = 0;
          memset(context->realbuf, 0, 256);
        }
      }
    } else if(rc == 0) {
      break;
    } else {
      break;
    }
  }
}

gboolean sappd_socket_callback(GIOChannel *channel, GIOCondition cond,
                               gpointer data)
{
  int rc, i;
  sapp_d_data *context;

  context = (sapp_d_data *)data;

  rc = recv(context->connection_sd, context->inbuf, 16, 0);
  if(rc == -1) {        /* do nothing */
  } else if(rc == 0) {  /* connection lost */
    if(context->state != SAPPD_STATE_INACTIVE) {  /* shouldn't be possible */
      context->state = SAPPD_STATE_ACTIVE;
    }
    context->quit_callback();
    /* or return FALSE? */
  } else {              /* normal procedure */
    for(i = 0; i < rc; i++) {
      context->realbuf[context->realbuflen] = context->inbuf[i];
      context->realbuflen++;
      if(context->inbuf[i] == '\n') {
        sappd_parse_realbuf(context);
        context->realbuflen = 0;
        memset(context->realbuf, 0, 256);
      }
    }

  }

  return TRUE;
}

gboolean sappd_confsock_callback(GIOChannel *channel, GIOCondition cond,
                                 gpointer data)
{
  int sd, rc;
  int received = 0;
  sapp_d_data *context;
  char jee[128];

  int val;
  char val2;
  char *bloo;

  context = (sapp_d_data *)data;

  struct sockaddr_un grr;
  socklen_t murr;

  sd = accept(context->gcq_sd, (struct sockaddr *)&grr, &murr);
  if(sd == -1) {        /* do nothing */
    return TRUE;
  } else if(sd == 0) {  /* interface lost? */
  } else {              /* normal procedure */
    do {
      rc = recv(sd, jee + received, 128 - received, 0);
      if(rc == 0) {
        close(sd);
        return TRUE;
        break;
      } else if(rc != -1) {
        received += rc;
      }
    } while (received < 128);

    if(jee[0] == 'i') {
      val = gconf_client_get_int(context->gconf_client, jee + 1, NULL);
      send(sd, &val, 4, 0);
      close(sd);
      return TRUE;
    } else if(jee[0] == 'b') {
      val2 = gconf_client_get_bool(context->gconf_client, jee + 1, NULL);
      send(sd, &val2, 1, 0);
      close(sd);
      return TRUE;
    } else if(jee[0] == 'a') {
      bloo = gconf_client_get_string(context->gconf_client, jee + 1, NULL);
      if(bloo == NULL) {
        send(sd, "ERR", 4, 0);
      } else {
        send(sd, bloo, strlen(bloo), 0);
      }
      close(sd);
      return TRUE;
    } else {
      send(sd, "ERR", 4, 0);
      close(sd);
      return TRUE;
    }
  }

  return TRUE;
}

int sappd_parse_realbuf(sapp_d_data *context)
{
/*int ret = 0;
  char *tmp_str;*/

  if(strncmp(context->realbuf, "bye", 3) == 0) {
    context->connstate = SAPPD_CONNSTATE_NONE;
    context->state = SAPPD_STATE_ACTIVE;
  /*context->quit_callback();*/
#ifdef SAPPD_DEBUG
    _sd_debugprint("we got a bye message");
#endif
  } else if(strncmp(context->realbuf, "quit", 4) == 0) {
    context->connstate = SAPPD_CONNSTATE_NONE;
    context->state = SAPPD_STATE_INACTIVE;
  /*context->quit_callback();*/
  } else if(strncmp(context->realbuf,  "pause", 5) == 0) {
    context->state = SAPPD_STATE_PAUSED;
    sappd_rpc(context, "game_pause");
  }

  return 0;
}

/* osso callback functions */
void sappd_osso_callback_top(const gchar *arguments, gpointer data)
{
  sapp_d_data *context;

  context = (sapp_d_data *)data;

  if(context->state != SAPPD_STATE_INACTIVE) { /* game is "active" */
    sappd_spawn(context, SAPPD_COMMAND_RUN);
    send(context->connection_sd, "top\n", 4, 0);
  }
}

gint sappd_osso_callback_rpc(const gchar *interface, const gchar *method,
                             GArray *arguments, gpointer data,
                             osso_rpc_t *retval)
{
  sapp_d_data *context;

  context = (sapp_d_data *)data;

  if(strncmp("game_run", method, 8) == 0 || strncmp("game_continue", method, 13) == 0) {
    sappd_spawn(context, SAPPD_COMMAND_RUN);
  } else if(strncmp("game_close", method, 10) == 0) {
    if(context->state != SAPPD_STATE_INACTIVE) {
      sappd_spawn(context, SAPPD_COMMAND_RESET);
    } else {
      g_main_loop_quit(context->mainloop);
#ifdef SAPPD_DEBUG
      _sd_debugprint("illegal operation: cannot reset when game inactive");
#endif
    }
  } else if(strncmp("game_restart", method, 12) == 0) {
    if(context->state != SAPPD_STATE_INACTIVE) {
      sappd_spawn(context, SAPPD_COMMAND_RESTART);
    } else {
      sappd_spawn(context, SAPPD_COMMAND_RUN);
    }
  }

  return 0;
}
