/**
 * @file sapp_ssetcb.c
 * shadow application library, game side library,
 * callback settinng part
 * <p>
 * Copyright (C) 2005 Nokia Corporation
 *
 * @author Kuisma Salonen <Kuisma.Salonen@nokia.com>
 */

/**********************************************************/

#include <sys/un.h>
#include <stdio.h>

#include "shadowapp.h"

int sapp_set_msg_cb_exit(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_exit = cb_func;

  return SAPP_ERROR_NONE;
}

int sapp_set_msg_cb_quit(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_quit = cb_func;

  return SAPP_ERROR_NONE;
}

int sapp_set_msg_cb_top(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_top = cb_func;

  return SAPP_ERROR_NONE;
}

int sapp_set_msg_cb_continue(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_continue = cb_func;

  return SAPP_ERROR_NONE;
}

int sapp_set_msg_cb_restart(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_restart = cb_func;

  return SAPP_ERROR_NONE;
}

int sapp_set_msg_cb_flush(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_flush = cb_func;

  return SAPP_ERROR_NONE;
}
