/**
 * @file sapp_main.c
 *
 * The mainloop implementation of shadow application library.
 * <p>
 * Copyright (C) 2005 Nokia Corporation
 *
 * @author Kuisma Salonen <kuisma.salonen@nokia.com>
 */


#include <memory.h>
#include <string.h>
#include <sys/un.h>
#include <sys/socket.h>

#include "shadowapp.h"

int sapp_mainloop(sapp_data *context, int flags)
{
  int i, rc;

  memset(context->inbuf, 0, 16);
  rc = recv(context->sockfd, context->inbuf, 16,
           (!(flags & SAPP_FLAGS_BLOCK))*MSG_DONTWAIT);
  if(rc == -1);
  else if(rc == 0) { /* conection lost */
    context->msg_cb_exit(SAPP_ERROR_CONNECTIONLOST);
    return SAPP_ERROR_CONNECTIONLOST;
  } else {

    for(i = 0; i < rc; i++) {
      context->realbuf[context->realbuflen] = context->inbuf[i];
      context->realbuflen++;
      if(context->inbuf[i] == '\n') {
        sapp_handle_received(context);
      /*context->realbuflen = 0;
        memset(context->realbuf, 0, SAPP_REALBUF_LEN);*/
      }
    }
  }

  return SAPP_ERROR_NONE;
}

int sapp_handle_received(sapp_data *parent)
{
  if(!strncmp(parent->realbuf, "bye", 3)) {
    parent->msg_cb_exit(SAPP_ERROR_BYE);
  } else if(!strncmp(parent->realbuf, "quit", 4)) {
    parent->msg_cb_flush(SAPP_ERROR_QUIT);
    parent->msg_cb_quit(SAPP_ERROR_QUIT);
  } else if(!strncmp(parent->realbuf, "top", 3)) {
    parent->msg_cb_top(SAPP_ERROR_NONE);
  } else if(!strncmp(parent->realbuf, "continue", 8)) {
    parent->msg_cb_continue(SAPP_ERROR_NONE);
  } else if(!strncmp(parent->realbuf, "restart", 7)) {
    parent->msg_cb_restart(SAPP_ERROR_NONE);
  }

  memset(parent->realbuf, 0, SAPP_REALBUF_LEN);
  parent->realbuflen = 0;

  return SAPP_ERROR_NONE;
}

int sapp_pause(sapp_data *context)
{
  if(context == NULL) {
    return SAPP_ERROR_INVALIDPARAMS;
  }

  send(context->sockfd, "pause\n", 6, 0);

  return SAPP_ERROR_NONE;
}
