/**
 * @file sapp_gconf.h
 *
 * Implementation of requesting gconf values through the wrapper.
 * <p>
 * Copyright (C) 2005 Nokia Corporation
 *
 * @author Kuisma Salonen <kuisma.salonen@nokia.com>
 */


#include <stdio.h>
#include <memory.h>
#include <unistd.h>
#include <sys/un.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "shadowapp.h"


int sapp_gconf_request_int(sapp_data *context, char *value_path, int *dest)
{
  int sd, rc;
  struct sockaddr_un target_addr;
  char request[128], response[32];
  int received = 0;

  memset(request, 0, 128);
  sprintf(request, "i%s", value_path);

  sd = socket(PF_UNIX, SOCK_STREAM, 0);
  if(sd == -1) {
    return SAPP_ERROR_SOCKET;
  }

  target_addr.sun_family = AF_UNIX;
  sprintf(target_addr.sun_path, "%s", context->configuration_socket);
  if(connect(sd, (struct sockaddr *)&target_addr,
             sizeof(struct sockaddr_un)) == -1) {
    close(sd);
    return SAPP_ERROR_CONNECTION;
  }

  if(send(sd, request, 128, 0) < 128) {
    close(sd);
    return SAPP_ERROR_CONNANOTHER;
  }

  memset(response, 0, 32);
  while((rc = recv(sd, response + received, 32 - received, 0)) != 0) {
    if(rc > 0) {
      received += rc;
    }
  }

  memcpy(dest, response, 4);

  return SAPP_ERROR_NONE;
}

int sapp_gconf_request_string(sapp_data *context, char *value_path, char *dest)
{
  int sd, rc;
  struct sockaddr_un target_addr;
  char request[128], response[512];  /* perhaps too large */
  int received = 0;

  memset(request, 0, 128);
  sprintf(request, "a%s", value_path);

  sd = socket(PF_UNIX, SOCK_STREAM, 0);
  if(sd == -1) {
    return SAPP_ERROR_SOCKET;
  }

  target_addr.sun_family = AF_UNIX;
  sprintf(target_addr.sun_path, "%s", context->configuration_socket);
  if(connect(sd, (struct sockaddr *)&target_addr,
             sizeof(struct sockaddr_un)) == -1) {
    close(sd);
    return SAPP_ERROR_CONNECTION;
  }

  if(send(sd, request, 128, 0) < 128) {
    close(sd);
    return SAPP_ERROR_CONNANOTHER;
  }

  memset(response, 0, 512);
  while((rc = recv(sd, response + received, 512 - received, 0)) != 0) {
    if(rc > 0) {
      received += rc;
    }
  }

  memcpy(dest, response, received + 1);

  if(response[0] == 'E' && response[1] == 'R' && response[2] == 'R') {
    return SAPP_ERROR_NOVALUE;
  }

  return SAPP_ERROR_NONE;
}

int sapp_gconf_request_bool(sapp_data *context, char *value_path, char *dest)
{
  int sd, rc;
  struct sockaddr_un target_addr;
  char request[128], response[32];
  int received = 0;

  memset(request, 0, 128);
  sprintf(request, "b%s", value_path);

  sd = socket(PF_UNIX, SOCK_STREAM, 0);
  if(sd == -1) {
    return SAPP_ERROR_SOCKET;
  }

  target_addr.sun_family = AF_UNIX;
  sprintf(target_addr.sun_path, "%s", context->configuration_socket);
  if(connect(sd, (struct sockaddr *)&target_addr,
             sizeof(struct sockaddr_un)) == -1) {
    close(sd);
    return SAPP_ERROR_CONNECTION;
  }

  if(send(sd, request, 128, 0) < 128) {
    close(sd);
    return SAPP_ERROR_CONNANOTHER;
  }

  memset(response, 0, 32);
  while((rc = recv(sd, response + received, 32 - received, 0)) != 0) {
    if(rc > 0) {
      received += rc;
    }
  }

  memcpy(dest, response, 1);

  return SAPP_ERROR_NONE;
}
