function czZoomElements(node, scaleFactor) {
	var childNodes = node.childNodes;

	var childNode = null;
	for (var i = 0; i < childNodes.length; i++) {
		childNode = childNodes[i];
		
		if (childNode.nodeType == 1) {
			czZoomElements(childNode, scaleFactor);
		}
    	}

	// for frames:
	if (node.contentDocument) {
			czZoomElements(node.contentDocument, scaleFactor);
	}

	try {
		if (node.localName == "IMG") {
			var width = node.ownerDocument.defaultView.getComputedStyle(node, "").getPropertyValue("width");
	       		width = width.substr(0, width.length - 2);
			var height = node.ownerDocument.defaultView.getComputedStyle(node, "").getPropertyValue("height");
	       		height = height.substr(0, height.length - 2);
			if ((width != 'au') && (height != 'au')) {
			    var origWidth  = node.origWidth;
			    var origHeight = node.origHeight;
			    if (origWidth && origHeight) {
				width = origWidth;
				height = origHeight;
			    } else {
				node.origWidth = width;
				node.origHeight = height;
			    }
        		    node.setAttribute("width", width * scaleFactor);
	       		    node.setAttribute("height", height * scaleFactor);
			}
		}
	} catch (e) {}

	//ZoomManager.prototype.getInstance().textZoom = 200;
	try {
		var fontSize = node.ownerDocument.defaultView.getComputedStyle(node, "").getPropertyValue("font-size");
                var origFontSize = node.origFontSize;
		if (origFontSize) {
			fontSize = origFontSize;
		} else {
			node.origFontSize = fontSize;
		}
       		fontSize = fontSize.substr(0, fontSize.length - 2);
		node.style.fontSize = (fontSize * scaleFactor) + "px";
	} catch (e) {}

	try {
		var lineHeight = node.ownerDocument.defaultView.getComputedStyle(node, "").getPropertyValue("line-height");
    		if (lineHeight != "normal") {
			var origLineHeight = node.origLineHeight;
			if (origLineHeight) {
				lineHeight = origLineHeight;
			} else {
				node.origLineHeight = lineHeight;
			}
			lineHeight = lineHeight.substr(0, lineHeight.length - 2);
		        node.style.lineHeight = (lineHeight * scaleFactor) + "px";
    		}
	} catch (e) {}
}



function Zoomer() { /* big comment for no code, eh? */ }

/* decorate prototype to provide ``class'' methods and property accessors */

Zoomer.prototype = {

    QueryInterface: function (iid) {

        if (iid.equals(Components.interfaces.nsIZoomer) ||

            iid.equals(Components.interfaces.nsISupports))
            return this;

        Components.returnCode = Components.results.NS_ERROR_NO_INTERFACE;
        return null;
    },

    zoom: function(node, factor) {

        czZoomElements(node, factor/100);
        return 0;
    }
}




var myModule = {
    firstTime: true,

    /*
     * RegisterSelf is called at registration time (component installation
     * or the only-until-release startup autoregistration) and is responsible
     * for notifying the component manager of all components implemented in
     * this module.  The fileSpec, location and type parameters are mostly
     * opaque, and should be passed on to the registerComponent call
     * unmolested.
     */
    registerSelf: function (compMgr, fileSpec, location, type) {
        if (this.firstTime) {
            debug("*** Deferring registration of sample JS components\n");
            this.firstTime = false;
            throw Components.results.NS_ERROR_FACTORY_REGISTER_AGAIN;
        }
        debug("*** Registering sample JS components\n");
        compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);

        compMgr.registerFactoryLocation(this.myCID,
                                        "Zoomer Component",
                                        this.myProgID,
                                        fileSpec,
                                        location,
                                        type);
    },

    /*
     * The GetClassObject method is responsible for producing Factory objects
     */
    getClassObject: function (compMgr, cid, iid) {
        if (!cid.equals(this.myCID))
            throw Components.results.NS_ERROR_NO_INTERFACE;

        if (!iid.equals(Components.interfaces.nsIFactory))
            throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

        return this.myFactory;
    },

    /* CID for this class */
    myCID: Components.ID("{68c45305-3813-4a3a-860e-a4967d15ca57}"),

    /* ProgID for this class */
    myProgID: "@mozilla.org/zoomer;1",

    /* factory object */
    myFactory: {
        /*
         * Construct an instance of the interface specified by iid, possibly
         * aggregating it with the provided outer.  (If you don't know what
         * aggregation is all about, you don't need to.  It reduces even the
         * mightiest of XPCOM warriors to snivelling cowards.)
         */
        createInstance: function (outer, iid) {
            debug("CI: " + iid + "\n");
            if (outer != null)
                throw Components.results.NS_ERROR_NO_AGGREGATION;

            return (new Zoomer()).QueryInterface(iid);
        }
    },

    /*
     * The canUnload method signals that the component is about to be unloaded.
     * C++ components can return false to indicate that they don't wish to be
     * unloaded, but the return value from JS components' canUnload is ignored:
     * mark-and-sweep will keep everything around until it's no longer in use,
     * making unconditional ``unload'' safe.
     *
     * You still need to provide a (likely useless) canUnload method, though:
     * it's part of the nsIModule interface contract, and the JS loader _will_
     * call it.
     */
    canUnload: function(compMgr) {
        debug("*** Unloading sample JS components\n");
        return true;
    }
};

function NSGetModule(compMgr, fileSpec) {
    return myModule;
}


