
#include "gmozillacontenthandler.h"
//#include "gmozillaengine.h"
#include "gtkmozembed.h"

#include <nsIPromptService.h>
#include <nsIWebProgressListener.h>
#include <nsCOMPtr.h>
//#define MOZILLA_INTERNAL_API
#include <nsIServiceManager.h>
//#undef MOZILLA_INTERNAL_API
#include <nsIInterfaceRequestorUtils.h>
#include <nsIURI.h>
#include <nsIURL.h>
#include <nsIMIMEInfo.h>
#include <nsILocalFile.h>
#include <nsIDOMWindow.h>
#include <nsIExternalHelperAppService.h>
#include <nsCExternalHandlerService.h>
#include <nsMemory.h>
#include <nsNetError.h>
#include <nsEmbedString.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <unistd.h>

class GContentHandler;
struct MimeAskActionDialog;

/*
 * MimeAskActionDialog: the representation of dialogs used to ask
 * about actions on MIME types
 */
struct MimeAskActionDialog
{
	MimeAskActionDialog(GContentHandler *aContentHandler,
			    GtkWidget *aParentWidget,
			    const char *aMimeType);
	~MimeAskActionDialog();

	GContentHandler* mContentHandler;
	GtkWidget *mDialogWidget;
	GtkWidget *mParent;
	GtkWidget *mListView;

	GList *mApps;

	enum
	{
		APP_COLUMN,
		N_COLUMNS
	};

	// How many rows to show in the applications list
	static const int NUM_APPLICATIONS = 4; 
};

/* ------------------------------------------------------------
 * Mini progress listener so that we can listen for errors
 * while downloading */
class MiniProgressListener
//#ifdef HAVE_NSIWEBPROGRESSLISTENER2_H
//	: public nsIWebProgressListener2
//#else
	: public nsIWebProgressListener
//#endif
{
	public:
		MiniProgressListener(MimeAskActionDialog *dialog) : 
			mDialog( dialog ) {};
			~MiniProgressListener() {};

		NS_DECL_ISUPPORTS
		NS_DECL_NSIWEBPROGRESSLISTENER
//#ifdef HAVE_NSIWEBPROGRESSLISTENER2_H
//	NS_DECL_NSIWEBPROGRESSLISTENER2
//#endif
	
	MimeAskActionDialog *mDialog;
};

//#ifdef HAVE_NSIWEBPROGRESSLISTENER2_H
//NS_IMPL_ISUPPORTS2(MiniProgressListener, nsIWebProgressListener2,
//		   nsIWebProgressListener)
//#else
NS_IMPL_ISUPPORTS1(MiniProgressListener,
		   nsIWebProgressListener)
//#endif

NS_IMPL_ISUPPORTS1(GContentHandler, nsIHelperAppLauncherDialog)

GContentHandler::GContentHandler() : mUri(nsnull)
{
	printf("GContentHandler::GContentHandler constructor(%p)\n", this );
}

GContentHandler::~GContentHandler()
{
	printf("GContentHandler::GContentHandler destructor(%p)", this);
}

NS_IMETHODIMP GContentHandler::PromptForSaveToFile(
				nsIHelperAppLauncher *aLauncher,
				nsISupports *aWindowContext,
				const PRUnichar *aDefaultFile,
				const PRUnichar *aSuggestedFileExtension,
				nsILocalFile **_retval)
{
	printf("GContentHandler::PromptForSaveToFile\n");
	
	//
	// INSERIR CODIGO AQUI
	//
	
	return NS_ERROR_FAILURE;
}

NS_METHOD GContentHandler::GetLauncher (nsIHelperAppLauncher * *_retval)
{
	printf("GContentHandler::GetLauncher\n");
	NS_IF_ADDREF (*_retval = mLauncher);
	return NS_OK;
}

NS_METHOD GContentHandler::GetContext (nsISupports * *_retval)
{
	printf("GContentHandler::GetContextr\n");
	NS_IF_ADDREF (*_retval = mContext);
	return NS_OK;
}


/*
NS_METHOD GContentHandler::CheckAppSupportScheme (void)
{
	printf("GContentHandler::CheckAppSupportScheme\n");
	g_return_val_if_fail (mHelperApp, NS_ERROR_FAILURE);

#ifdef HAVE_NEW_GNOME_VFS_MIME_API

	// There is no way to get the supported schemes in the new API 
//	mUrlHelper = gnome_vfs_mime_application_supports_uris (mHelperApp);
//#else
	mUrlHelper = FALSE;

	if (mHelperApp->expects_uris != GNOME_VFS_MIME_APPLICATION_ARGUMENT_TYPE_URIS)
	{
		return NS_OK;
	}
	
	GList *l;
	for (l = mHelperApp->supported_uri_schemes; l != NULL; l = l->next)
	{
		char *uri_scheme = (char *)l->data;
		g_return_val_if_fail (uri_scheme != NULL, FALSE);
		if (mScheme.Equals (uri_scheme))
		{
			mUrlHelper = TRUE;
			return NS_OK;
		}
	}
#endif

	return NS_OK;
}



NS_METHOD GContentHandler::SetHelperApp(GnomeVFSMimeApplication *aHelperApp,
					PRBool alwaysUse)
{
	printf("GContentHandler::SetHelperApp\n");
	mHelperApp = aHelperApp;

	CheckAppSupportScheme();

	return NS_OK;
}


NS_METHOD GContentHandler::SynchroniseMIMEInfo (void)
{
	printf("GContentHandler::SynchroniseMIMEInfo\n");
	nsresult rv;
	nsCOMPtr<nsIMIMEInfo> mimeInfo;
	rv = mLauncher->GetMIMEInfo(getter_AddRefs(mimeInfo));
	if(NS_FAILED(rv)) return NS_ERROR_FAILURE;

	// XXX information passing kludge (to ProgressListener)
	// TODO: should probably use some prefix, like 'gnomevfs:'
	
	const char * id;
#ifdef HAVE_NEW_GNOME_VFS_MIME_API
	id = gnome_vfs_mime_application_get_desktop_id (mHelperApp);
#else
	id = mHelperApp->id;
#endif

	// The current time is fine here as the user has just clicked
	//* a button (it is used as the time for the application opening) 
	char * info = g_strdup_printf ("%d:%s", gtk_get_current_event_time(),
				       id);

	//NS_CStringToUTF16 (NS_ConvertUTF8toUTF16(info2.get(), NS_CSTRING_ENCODING_UTF8, info2);
				       
	//rv = mimeInfo->SetApplicationDescription (NS_ConvertUTF8toUTF16(info2).get());
	
	
	
//#ifdef HAVE_NSIMIMEINFO_NSASTRING
//		(nsAString(info));
//#else
//		(NS_ConvertUTF16toUTF8(info).get());
//#endif
	//g_free (info);

	if(NS_FAILED(rv)) return NS_ERROR_FAILURE;

	rv = mimeInfo->SetPreferredAction(nsIMIMEInfo::useHelperApp);
	if(NS_FAILED(rv)) return NS_ERROR_FAILURE;

	return NS_OK;
}
	*/

// where everything starts
NS_IMETHODIMP GContentHandler::Show(nsIHelperAppLauncher *aLauncher,
				    nsISupports *aContext,
				    PRUint32 aForced)
{
	printf("GContentHandler::Show\n");
	nsresult rv;

	GtkWidget *label = gtk_label_new("huaehuae");
	
	mLauncher = aLauncher;
	mContext = aContext;
	rv = Init ();
	
/*	GObject *teste = g_mozilla_engine_new();
	
	if (cur_engine == NULL) 
		printf("cur_engine is null\n");
	else
		if (cur_engine->engine == NULL)
			printf("cur_engine->engine is null\n");
		else
			printf("cur_engine->engine is not null\n");
*/	
	GtkMozEmbed *mOwner;

	//mOwner = gtk_moz_embed_new();

	//g_signal_emit_by_name(G_OBJECT(mOwner), moz_embed_signals[DOWNLOAD_REQUEST], "url", "suggested_filename", "mimetype", 340, 500);
	printf("after emit\n");
	
	MIMEAskAction();

	return NS_OK;
}

// init download
NS_METHOD GContentHandler::Init (void)
{
	printf("GContentHandler::Init\n");
	nsresult rv;

	// get file mimetype
	nsCOMPtr<nsIMIMEInfo> MIMEInfo;
	rv = mLauncher->GetMIMEInfo (getter_AddRefs(MIMEInfo));
	rv = MIMEInfo->GetMIMEType (mMimeType);
	printf("MimeType: %s\n", mMimeType.get());
	
	// get source url
	rv = mLauncher->GetSource(getter_AddRefs(mUri));
	nsCAutoString spec;
	rv = mUri->Resolve(NS_LITERAL_CSTRING("."), spec);	
	printf("Download From: %s\n", spec.get());	
	
	// get file size
	rv = mLauncher->GetTargetFile(getter_AddRefs(mTempFile));
	PRInt64 filesize;
	mTempFile->GetFileSize(&filesize);
	printf("File Size: %d\n", filesize);
	
	rv = mUri->GetSpec (mUrl);
	rv = mUri->GetScheme (mScheme);

	//nsCOMPtr<nsIHelperAppLauncher> launcher;
	//this->GetLauncher(getter_AddRefs(launcher));	
	
	//nsCOMPtr<nsIURI> source;
	//launcher->GetSource(getter_AddRefs(source));

	//nsCAutoString spec;
	//rv = mUri->Resolve(NS_LITERAL_CSTRING("."), spec);	
	//printf("Download From: %s\n", spec.get());
	
	// get suggested filename
	nsAutoString uFilename;
	rv = mLauncher->GetSuggestedFileName (uFilename);	
	printf("Suggested File Name: %s\n", NS_ConvertUTF16toUTF8(uFilename).get());
	
	ProcessMimeInfo ();

	return NS_OK;
}

NS_METHOD GContentHandler::ProcessMimeInfo (void)
{
	printf("GContentHandler::ProcessMimeInfo\n");

	if (mMimeType.IsEmpty() ||
		   mMimeType.Equals("application/octet-stream"))
	{
		printf("mMimeType is Empty\n");
		
		// suggested filename
		nsAutoString uriFileName;

		nsAutoString filename;
		mLauncher->GetSuggestedFileName (filename);
		uriFileName = filename;

		//mMimeType.Assign(gnome_vfs_mime_type_from_name
		//		(NS_ConvertUTF16toUTF8(uriFileName).get()));
	}
	return NS_OK;
}

NS_METHOD GContentHandler::MIMEAskAction (void)
{
	printf("GContentHandler::MIMEAskAction\n");
	nsCOMPtr<nsIDOMWindow> parent = do_GetInterface(mContext);
	//GtkWidget *parentWidget = GaleonUtils::FindGtkParent(parent);

	GtkWidget *parentWidget = NULL;
	
	MimeAskActionDialog *dialog =
			new MimeAskActionDialog(this, parentWidget, mMimeType.get());

	/* Create a mini progress listener while the mime ask action
	* dialog is being displayed. Using this listener, we can catch
	* errors while the download is happening to a temporary file
	* - bug 148739
	*/
//#ifdef HAVE_NSIWEBPROGRESSLISTENER2_H
//	nsCOMPtr<nsIWebProgressListener2> listener = new MiniProgressListener( dialog );
//#else
//	nsCOMPtr<nsIWebProgressListener> listener = new MiniProgressListener( dialog );
//#endif
//	mLauncher->SetWebProgressListener( listener );

	return NS_OK;
}

MimeAskActionDialog::MimeAskActionDialog(GContentHandler *aContentHandler,
					 GtkWidget *aParentWidget,
					 const char *aMimeType) :
				mContentHandler(aContentHandler),
					 mParent(aParentWidget)
{
	printf("GContentHandler::MimeAskActionDialog\n");
	
	/*
	GtkWidget *label;
	//GladeXML *GXml;
	char *markup;
	//LOG ("MimeAskActionDialog ctor(%p)", this );

	printf("passou 1\n");
	mApps = gnome_vfs_mime_get_all_applications(aMimeType);
	if (mApps)
	{
		GtkListStore * liststore;

		//GXml = gul_glade_widget_new("galeon.glade",
		//			    "mime_ask_open_dialog", 
		//			    &mDialogWidget, this);

		//mListView = glade_xml_get_widget(GXml, "mime_ask_dialog_helper_list_view");

		mDialogWidget = gtk_dialog_new();
		
		GnomeVFSMimeApplication *defaultApp =
				gnome_vfs_mime_get_default_application(aMimeType);

		
		char *title;
		if (defaultApp)
		{
			title = g_strdup_printf (_("Open this file with \"%s\"?"), defaultApp->name);
		}
		else
		{
			// can this actually happen?
			title = g_strdup (_("Open this file with another application?"));
		}
		
		markup = g_strdup_printf ("<span size=\"larger\" weight=\"bold\">%s</span>", "title");
		//g_free (title);
		
		
		//label = glade_xml_get_widget(GXml, "mime_ask_action_title");
		label = gtk_label_new("label hehehe");
		gtk_label_set_markup (GTK_LABEL(label), markup);
		g_free (markup);


		liststore = gtk_list_store_new(N_COLUMNS,
					       G_TYPE_STRING);
		//gtk_tree_view_set_model(GTK_TREE_VIEW(mListView),
		//			GTK_TREE_MODEL(liststore));

		GtkCellRenderer *renderer;
		renderer = gtk_cell_renderer_text_new();

		GtkTreeViewColumn *column;
		column = gtk_tree_view_column_new_with_attributes("Application",
				renderer,
				"text", APP_COLUMN,
				NULL);
		//gtk_tree_view_append_column(GTK_TREE_VIEW(mListView), column);

		//GtkTreeSelection *selection =
		//		gtk_tree_view_get_selection(GTK_TREE_VIEW(mListView));
		//gtk_tree_selection_set_mode(selection, GTK_SELECTION_SINGLE);

		printf("passou 2\n");
		
		
		guint index;
		for (GList *i = mApps ; i ; i = i->next, index++)
		{
			GnomeVFSMimeApplication *app =
					static_cast<GnomeVFSMimeApplication *>(i->data);

			GtkTreeIter iter;
			gtk_list_store_append (liststore, &iter);
			gtk_list_store_set (liststore, &iter,
					    APP_COLUMN, app->name,
					    -1);

			//if (defaultApp &&
			//			 !g_ascii_strcasecmp(app->name, defaultApp->name))
			//{
			//	gtk_tree_selection_select_iter(selection, &iter);
			//}
		}

		g_object_unref (liststore);
		
		
		// Calculate the correct width for the list view for showing
		// NUM_APPLICATION rows.
		gint width, height, ypad;
		//gtk_cell_renderer_get_size (renderer, GTK_WIDGET (mListView),
		//			    NULL, NULL, NULL, &width, &height);
		//g_object_get (renderer, "ypad", &ypad, NULL);
		//height = NUM_APPLICATIONS*(height + ypad) + 2*ypad;
		//gtk_widget_set_size_request (GTK_WIDGET (mListView), 0, height);
	
		printf("passou 3\n");
	}
	else
	{
		//GXml = gul_glade_widget_new("galeon.glade",
		//			    "mime_ask_save_dialog", 
		//			    &mDialogWidget, this);
		//GtkWidget *w;
		//w = glade_xml_get_widget(GXml, "mime_ask_dialog_save");
		//gtk_widget_grab_default (w);
		printf("passou 4\n");
	}

	//GtkWidget *mimeIcon = glade_xml_get_widget(GXml,
	//		"mime_ask_action_icon");
	//gul_gui_image_set_from_mime_type (mimeIcon, 
	//				  aMimeType, GTK_ICON_SIZE_DIALOG);

	
			
	nsCOMPtr<nsIHelperAppLauncher> launcher;
	(void)mContentHandler->GetLauncher(getter_AddRefs(launcher));
	
	// suggested filename
	
	nsAutoString filename;
//#ifdef HAVE_NSIMIMEINFO_NSASTRING
	nsAutoString uFilename;
	launcher->GetSuggestedFileName (uFilename);
	filename = uFilename;
	
	printf("Suggested File Name: %s\n", NS_ConvertUTF16toUTF8(uFilename).get());
	
	printf("passou 5\n");
	*/
	//#else
//	PRUnichar *uFilename = nsnull;
//	launcher->GetSuggestedFileName(&uFilename);
//	filename = uFilename;
//	nsMemory::Free(uFilename);
	
//	printf("Suggested File Name: %s\n", uFilename.get());
//#endif
	
	//markup = g_markup_printf_escaped("<b>%s</b>", filename.get());

	//label = glade_xml_get_widget(GXml, "mime_ask_action_name");
	//gtk_label_set_markup(GTK_LABEL(label), markup);
	//g_free (markup);

	// MIME type description
	//const char *description = gnome_vfs_mime_get_description(aMimeType);
	//if (!description) description = aMimeType;
	
	//label = glade_xml_get_widget(GXml, "mime_ask_action_description");
	//gtk_label_set_text(GTK_LABEL(label), description);

	
	// source
	
	/*
	nsCOMPtr<nsIURI> source;
	launcher->GetSource(getter_AddRefs(source));

	nsCAutoString spec;
	source->Resolve(NS_LITERAL_CSTRING("."), spec);
	
	printf("Download From: %s\n", spec.get());
	
	printf("passou 6\n");
	*/
	//markup = g_strdup_printf ("<i>%s</i>", spec.get());
	//label = glade_xml_get_widget(GXml, "mime_ask_action_source");
	//gtk_label_set_markup(GTK_LABEL("label mime_ask_action_source"), markup);
	//g_free (markup);

	//gtk_window_set_transient_for(GTK_WINDOW(mDialogWidget), 
	//			     GTK_WINDOW(aParentWidget));

	//gtk_widget_show(mDialogWidget);

	//g_object_unref(G_OBJECT(GXml));
	

}

MimeAskActionDialog::~MimeAskActionDialog()
{
	printf("MimeAskActionDialog::~MimeAskActionDialog()\n");
	//LOG ("MimeAskActionDialog dtor(%p)", this );

	//if(mApps)
	//	gnome_vfs_mime_application_list_free(mApps);

	gtk_widget_destroy(mDialogWidget);
}

//
// METHODS OVERRIDEN FROM nsIWebProgressListener Interface (which MiniProgressListener inherits)
//

NS_IMETHODIMP MiniProgressListener::OnStatusChange(nsIWebProgress *aWebProgress, 
		nsIRequest *aRequest, nsresult aStatus, 
		const PRUnichar *aMessage)
{
	printf("MiniProgressListener::OnStatusChange\n");
	
	if (NS_SUCCEEDED (aStatus)) return NS_OK;

	/* When the save fails, the mozilla code will call this, and
	* after this point, the launcher isn't valid for some reason
	* so we need to display an error, and get out of this code
	* quickly */
	//GtkWidget *dialog = 
	//		hig_alert_new (GTK_WINDOW (mDialog->mParent), 
	//			       (GtkDialogFlags)0,
	//			       1, // HIG_ALERT_ERROR
	//			       ("Failed to Save File."),
	//			       nsCAutoString (aMessage).get(),
	//			       GTK_STOCK_OK, GTK_RESPONSE_OK,
	//			       NULL);

	delete mDialog; /* Close, and delete the MIME dialog */
	mDialog = NULL;

	//gtk_dialog_run (GTK_DIALOG (dialog));
	//gtk_widget_destroy (dialog);

	return NS_OK;
}

NS_IMETHODIMP MiniProgressListener::OnStateChange(nsIWebProgress *aWebProgress, 
		nsIRequest *aRequest, PRUint32 aStateFlags, 
		nsresult aStatus)
{
	printf("MiniProgressListener::OnStateChange\n");
	return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP MiniProgressListener::OnProgressChange(nsIWebProgress *aWebProgress, 
		nsIRequest *aRequest, PRInt32 aCurSelfProgress,
		PRInt32 aMaxSelfProgress, PRInt32 aCurTotalProgress,
		PRInt32 aMaxTotalProgress)
{
	printf("MiniProgressListener::OnProgressChange\n");
	return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP MiniProgressListener::OnLocationChange(nsIWebProgress *aWebProgress, 
		nsIRequest *aRequest, nsIURI *location)
{
	printf("MiniProgressListener::OnLocationChange\n");
	return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP MiniProgressListener::OnSecurityChange(nsIWebProgress *aWebProgress, 
		nsIRequest *aRequest, PRUint32 state)
{
	printf("MiniProgressListener::OnSecurityChange\n");
	return NS_ERROR_NOT_IMPLEMENTED;
}

/*
#ifdef HAVE_NSIWEBPROGRESSLISTENER2_H
NS_IMETHODIMP MiniProgressListener::OnProgressChange64(nsIWebProgress *aWebProgress,
		nsIRequest *aRequest, PRInt64 aCurSelfProgress,
		PRInt64 aMaxSelfProgress, PRInt64 aCurTotalProgress,
		PRInt64 aMaxTotalProgress)
{
	printf("MiniProgressListener::OnProgressChange64\n");
	return NS_ERROR_NOT_IMPLEMENTED;
}
#endif
*/
