/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Christopher Blizzard. Portions created by Christopher Blizzard are Copyright (C) Christopher Blizzard.  All Rights Reserved.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Christopher Blizzard <blizzard@mozilla.org>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __EmbedProgress_h
#define __EmbedProgress_h

#include <nsIWebProgressListener.h>
#include <nsWeakReference.h>
#include "EmbedPrivate.h"

//TONIKITOO
#include "nsIDocShell.h"
#include "gtkmozembed_internal.h"

/* Mozilla includes */
#include "gtkmozembed.h"
#include "gtkmozembed_internal.h"
#include "prenv.h"
#include "nsMemory.h"
/* Includes used by Find features */
#include "nsIWebBrowser.h"
#include "nsIWebBrowserFind.h"
#include "nsNetUtil.h"

/* Includes used by 'mozilla_preference_set', 'mozilla_preference_set_int' and 'mozilla_preference_set_boolean' */
#include "nsIPref.h"

/* Includes used by 'save_mozilla' */
#include "nsIPresShell.h"
#include "nsIDocShell.h"
#include "nsIDOMDocument.h"
#include "nsIWebBrowserPersist.h"
#include "nsIWebNavigation.h"
#include "nsIDocShellTreeItem.h"
#include "nsILocalFile.h"
#include "nsIDocShellTreeOwner.h"
#include "nsIDocument.h"

#include "nsVoidArray.h"
#include "nsIPresShell.h"
#include "nsIDOMStyleSheetList.h"
#include "nsIDOMStyleSheet.h"
#include "nsIClipboardCommands.h"
#include "nsIIOService.h"

#include "nsIContentViewer.h"
#include "nsIDOMKeyEvent.h"

#include "nsIWebBrowserFocus.h"

/* Includes used by context menus */
#include "nsIDOMMouseEvent.h"
#include "nsIDOMNSEvent.h"
#include "nsIDOMEventTarget.h"
#include "nsIDOMHTMLElement.h"
#include "nsIDOMNamedNodeMap.h"
#include "nsIDOMNSHTMLElement.h"

/* Includes shared by context menus e cache :) */
#include "nsIDOMNSDocument.h"

// includes used by the Enconding methods
#include "nsIDocCharset.h"
#include "nsIInterfaceRequestorUtils.h"

// includes used by the Cache methods and GetPageSize methods
#include "nsICacheEntryDescriptor.h"
#include "nsICacheService.h"
#include "nsICacheSession.h"
#include "nsIDOMNSDocument.h"
#include "nsIDOMLocation.h"
#include "nsCOMPtr.h"
#include "nsIContentViewer.h"
#include "nsNetCID.h"
#include "nsIInterfaceRequestorUtils.h" //do_GetInterface
#include "nsServiceManagerUtils.h"  	//do_GetService
#include "nsStringAPI.h"  		//nsACString
#include "nsEmbedString.h"

//handling string easily
#include "GulString.h"

class EmbedProgress : public nsIWebProgressListener,
                      public nsSupportsWeakReference
{
 public:
  EmbedProgress();
  virtual ~EmbedProgress();

  nsresult Init(EmbedPrivate *aOwner);

  NS_DECL_ISUPPORTS

  NS_DECL_NSIWEBPROGRESSLISTENER

 private:

  static void RequestToURIString (nsIRequest *aRequest, char **aString);

  static int GetEncoding (GtkMozEmbed *);

  static nsresult GetCacheEntryDescriptor(const nsAString &, nsICacheEntryDescriptor **);

  static int GetPageSize (GtkMozEmbed *);

  EmbedPrivate *mOwner;

  PRBool isFramed;
};

#endif /* __EmbedProgress_h */
