#include <string.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include <gconf/gconf-client.h>

void
on_comboboxentry_changed              (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
    printf("Has been choosed engine: %s\n", gtk_combo_box_get_active_text(combobox));
    GConfClient *gconf_client;
    gchar *gconf_path;
    GError *error = NULL;

    gconf_client = gconf_client_get_default();

    gconf_path = g_strdup("/apps/osso/browser/engine");

    gconf_client_set_string ( gconf_client,
                                        gconf_path,
					gtk_combo_box_get_active_text(combobox),
                                        &error );
    gtk_main_quit();
}

int
main (int argc, char *argv[])
{

  gtk_init (&argc, &argv);


  GtkWidget *window;
  GtkWidget *frame;
  GtkWidget *alignment;
  GtkWidget *comboboxentry;
  GtkWidget *label;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Browser Engine Chooser");
  gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (window), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (window), GDK_WINDOW_TYPE_HINT_DIALOG);
  gtk_window_set_gravity (GTK_WINDOW (window), GDK_GRAVITY_SOUTH);

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_container_add (GTK_CONTAINER (window), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 6);

  alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (frame), alignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 0, 0, 12, 0);

  comboboxentry = gtk_combo_box_entry_new_text ();
  gtk_widget_show (comboboxentry);
  gtk_container_add (GTK_CONTAINER (alignment), comboboxentry);
  gtk_container_set_border_width (GTK_CONTAINER (comboboxentry), 3);
  gtk_combo_box_append_text (GTK_COMBO_BOX (comboboxentry), "opera");
  gtk_combo_box_append_text (GTK_COMBO_BOX (comboboxentry), "mozilla");
  gtk_combo_box_append_text (GTK_COMBO_BOX (comboboxentry), "webcore");

  label = gtk_label_new ("<b>Browser Engine Chooser</b>");
  gtk_widget_show (label);
  gtk_frame_set_label_widget (GTK_FRAME (frame), label);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);

  g_signal_connect ((gpointer) comboboxentry, "changed",
                    G_CALLBACK (on_comboboxentry_changed),
                    NULL);
  gtk_widget_show(window);

  gtk_main ();

    return 0;
}
