/**
  * Web Engine Abstraction Layer.
  * @file gwebtransferitem.c: Transfer Item Interface Implementation
  * @version $Rev: 2092 $
  * @date $LastChangedDate: 2005-11-01 14:53:00 +0200 (Tue, 01 Nov 2005) $
  *
  * Copyright (C) 2005 Nokia Corporation.
  *
  * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public License
  * as published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA
  *
  */

#include "gwebtransferitem.h"

static void
g_web_transfer_item_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;

	if (!initialized) {
		/* create interface signals here. */
		initialized = TRUE;
	}
}

GType
g_web_transfer_item_get_type (void)
{
    static GType type = 0;
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof (GWebTransferItemIface),
            g_web_transfer_item_base_init,   /* base_init */
            NULL,   /* base_finalize */
            NULL,   /* class_init */
            NULL,   /* class_finalize */
            NULL,   /* class_data */
            0,
            0,      /* n_preallocs */
            NULL    /* instance_init */
        };
        type = g_type_register_static (G_TYPE_INTERFACE, "GWebTransferItem", &info, 0);
    }
    return type;
}

void
g_web_transfer_item_destroy (GWebTransferItem *self)
{
	G_WEB_TRANSFER_ITEM_GET_CLASS (self)->destroy (self);
}

void
g_web_transfer_item_start (GWebTransferItem *self)
{
	G_WEB_TRANSFER_ITEM_GET_CLASS (self)->start (self);
}

void
g_web_transfer_item_stop (GWebTransferItem *self)
{
	G_WEB_TRANSFER_ITEM_GET_CLASS (self)->stop (self);
}

GWebStatus
g_web_transfer_item_continue (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->do_continue (self);
}

void
g_web_transfer_item_cancel (GWebTransferItem *self)
{
	G_WEB_TRANSFER_ITEM_GET_CLASS (self)->cancel (self);
}

void
g_web_transfer_item_reload (GWebTransferItem *self)
{
	G_WEB_TRANSFER_ITEM_GET_CLASS (self)->reload (self);
}

GObject*
g_web_transfer_item_get_web_item (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->get_web_item (self);
}

const gchar*
g_web_transfer_item_get_url (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->get_url (self);
}

const gchar*
g_web_transfer_item_get_filename (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->get_filename (self);
}

glong
g_web_transfer_item_get_total_size (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->get_total_size (self);
}

glong
g_web_transfer_item_get_progress (GWebTransferItem *self)
{
	return G_WEB_TRANSFER_ITEM_GET_CLASS (self)->get_progress (self);
}
