/**
  * Web Engine Abstraction Layer.
  * @file gwebpassman.c: Password Manager Interface Implementation
  * @version $Rev: 2092 $
  * @date $LastChangedDate: 2005-11-01 14:53:00 +0200 (Tue, 01 Nov 2005) $
  *
  * Copyright (C) 2005 Nokia Corporation.
  *
  * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public License
  * as published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA
  *
  */

#include "gwebpassman.h"

static void
g_web_password_manager_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;

	if (!initialized) {
		/* create interface signals here. */
		initialized = TRUE;
	}
}

GType
g_web_password_manager_get_type (void)
{
    static GType type = 0;
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof (GWebPasswordManagerIface),
            g_web_password_manager_base_init,   /* base_init */
            NULL,   /* base_finalize */
            NULL,   /* class_init */
            NULL,   /* class_finalize */
            NULL,   /* class_data */
            0,
            0,      /* n_preallocs */
            NULL    /* instance_init */
        };
        type = g_type_register_static (G_TYPE_INTERFACE, "GWebPasswordManager", &info, 0);
    }
    return type;
}

GType      g_web_password_manager_get_type         (void);

GWebStatus
g_web_password_manager_get_login_username (GWebPasswordManager *self, gchar** username)
{
        return G_WEB_PASSWORD_MANAGER_GET_CLASS (self)->get_login_username (self, username);
}

GWebStatus
g_web_password_manager_get_login_password(GWebPasswordManager*self, gchar** password)
{
        return G_WEB_PASSWORD_MANAGER_GET_CLASS (self)->get_login_password (self, password);
}

GObject* 
g_web_password_manager_login_get_personal_data(GWebPasswordManager *self)
{
        return G_WEB_PASSWORD_MANAGER_GET_CLASS (self)->login_get_personal_data (self);
}
