/**
  * Web Engine Abstraction Layer.
  * @file gwebengine.c: Web Engine Interface Implementation
  * @version $Rev: 2092 $
  * @date $LastChangedDate: 2005-11-01 14:53:00 +0200 (Tue, 01 Nov 2005) $
  *
  * Copyright (C) 2005 Nokia Corporation.
  *
  * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public License
  * as published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA
  *
  */

#include "gwebengine.h"

static void
g_web_engine_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;

	if (!initialized) {
		/* create interface signals here. */
		initialized = TRUE;
	}
}

GType
g_web_engine_get_type (void)
{
    static GType type = 0;
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof (GWebEngineIface),
            g_web_engine_base_init,   /* base_init */
            NULL,   /* base_finalize */
            NULL,   /* class_init */
            NULL,   /* class_finalize */
            NULL,   /* class_data */
            0,
            0,      /* n_preallocs */
            NULL    /* instance_init */
        };
        type = g_type_register_static (G_TYPE_INTERFACE, "GWebEngine", &info, 0);
    }
    return type;
}

void
g_web_engine_destroy (GWebEngine *self)
{
	G_WEB_ENGINE_GET_CLASS (self)->destroy (self);
}

void
g_web_engine_reset (GWebEngine *self)
{
	G_WEB_ENGINE_GET_CLASS (self)->reset (self);
}

void
g_web_engine_load_url (GWebEngine *self, const gchar *url)
{
	G_WEB_ENGINE_GET_CLASS (self)->load_url (self, url);
}

GWebStatus
g_web_engine_load_follow_link (GWebEngine *self, const gchar *url)
{
	return G_WEB_ENGINE_GET_CLASS (self)->load_follow_link (self, url);
}

GWebStatus
g_web_engine_load_url_with_css (GWebEngine *self, const gchar *url, const gchar *cssfile)
{
	return G_WEB_ENGINE_GET_CLASS (self)->load_url_with_css (self, url, cssfile);
}

void
g_web_engine_load_url_with_js (GWebEngine *self, gboolean  enable)
{
	G_WEB_ENGINE_GET_CLASS (self)->load_url_with_js (self, enable);
}

void
g_web_engine_load_home_page (GWebEngine *self)
{
	G_WEB_ENGINE_GET_CLASS (self)->load_home_page (self);
}

void
g_web_engine_stop_load (GWebEngine *self)
{
	G_WEB_ENGINE_GET_CLASS (self)->stop_load (self);
}

void
g_web_engine_reload (GWebEngine *self)
{
	G_WEB_ENGINE_GET_CLASS (self)->reload (self);
}

void
g_web_engine_go_back (GWebEngine *self, guint nsteps)
{
	G_WEB_ENGINE_GET_CLASS (self)->go_back (self, nsteps);
}

void
g_web_engine_go_forward (GWebEngine *self, guint nsteps)
{
	G_WEB_ENGINE_GET_CLASS (self)->go_forward (self, nsteps);
}

gboolean
g_web_engine_can_go_back (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->can_go_back (self);
}

gboolean
g_web_engine_can_go_forward (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->can_go_forward (self);
}

void
g_web_engine_zoom_by_steps (GWebEngine *self, guint relative_zoom, guint* legal_zoom_value)
{
	G_WEB_ENGINE_GET_CLASS (self)->zoom_by_steps (self, relative_zoom, legal_zoom_value);
}

void
g_web_engine_set_zoom_level (GWebEngine *self, gint level)
{
	G_WEB_ENGINE_GET_CLASS (self)->set_zoom_level (self, level);
}


GWebStatus
g_web_engine_set_zoom_level_around_point (GWebEngine *self, guint x, guint y, gint level)
{
	return G_WEB_ENGINE_GET_CLASS (self)->set_zoom_level_around_point (self, x, y, level);
}

GWebStatus
g_web_engine_compare_frames_zoom_level (GWebEngine *self, gboolean *equal)
{
	return G_WEB_ENGINE_GET_CLASS (self)->compare_frames_zoom_level (self, equal);
}

GWebStatus
g_web_engine_get_image_properties (GWebEngine *self, const gchar *url, gchar **file_type, guint *file_size, guint *width, guint *height)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_image_properties (self, url, file_type, file_size, width, height);
}

GWebStatus
g_web_engine_get_frame_properties (GWebEngine *self, gchar **file_type, guint *file_size, GWebEngineEncoding *file_encoding, guint *security, gboolean *automatic_encoding)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_frame_properties (self, file_type, file_size, file_encoding, security, automatic_encoding);
}

GWebStatus
g_web_engine_load_image (GWebEngine *self, const gchar* url)
{
	return G_WEB_ENGINE_GET_CLASS (self)->load_image (self, url);
}

gint
g_web_engine_get_back_window_history_list (GWebEngine *self, GObject **history)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_back_window_history_list (self, history);
}

gint
g_web_engine_get_forward_window_history_list (GWebEngine *self, GObject **history)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_forward_window_history_list (self, history);
}

guint
g_web_engine_get_zoom_level (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_zoom_level (self);
}

void
g_web_engine_set_frame_zoom_level (GWebEngine *self, guint level)
{
	G_WEB_ENGINE_GET_CLASS (self)->set_frame_zoom_level (self, level);
}

guint
g_web_engine_get_frame_zoom_level (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_frame_zoom_level (self);
}

void
g_web_engine_set_layout_mode (GWebEngine *self, GWebEngineLayoutMode mode)
{
	G_WEB_ENGINE_GET_CLASS (self)->set_layout_mode (self, mode);
}

GWebEngineLayoutMode
g_web_engine_get_layout_mode (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_layout_mode (self);
}

void
g_web_engine_set_load_images (GWebEngine *self, GWebEngineImagePolicy level)
{
	G_WEB_ENGINE_GET_CLASS (self)->set_load_images (self, level);
}

GWebEngineImagePolicy
g_web_engine_get_load_images (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_load_images (self);
}

void
g_web_engine_set_frame_stacking (GWebEngine *self, gboolean enabled)
{
	G_WEB_ENGINE_GET_CLASS (self)->set_frame_stacking (self, enabled);
}

gboolean
g_web_engine_get_frame_stacking (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_frame_stacking (self);
}

GWebStatus
g_web_engine_save_web_page (GWebEngine *self, GWebEngineSaveAction setting, const gchar *file_name_with_path)
{
	return G_WEB_ENGINE_GET_CLASS (self)->save_web_page (self, setting, file_name_with_path);
}

GWebStatus
g_web_engine_save_current_frame (GWebEngine *self, GWebEngineSaveAction setting, const gchar *file_name_with_path)
{
	return G_WEB_ENGINE_GET_CLASS (self)->save_current_frame (self, setting, file_name_with_path);
}

const gchar*
g_web_engine_get_frame_title (GWebEngine *self, gint frame_number)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_frame_title (self, frame_number);
}

gint
g_web_engine_get_frame_number (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_frame_number (self);
}

GWebStatus
g_web_engine_save_web_page_image (GWebEngine *self, const gchar *url, const gchar* directory)
{
	return G_WEB_ENGINE_GET_CLASS (self)->save_web_page_image (self, url, directory);
}

void
g_web_engine_select_all_text (GWebEngine *self)
{
	G_WEB_ENGINE_GET_CLASS (self)->select_all_text (self);
}

void
g_web_engine_set_language_encoding (GWebEngine *self, GWebEngineEncoding encoding)
{
	G_WEB_ENGINE_GET_CLASS (self)->set_language_encoding (self, encoding);
}

void
g_web_engine_set_frame_encoding (GWebEngine *self, GWebEngineEncoding encoding)
{
	G_WEB_ENGINE_GET_CLASS (self)->set_frame_encoding (self, encoding);
}

gboolean
g_web_engine_find_text (GWebEngine *self, const gchar *string, gboolean reverse, gboolean whole_word, gboolean case_sensitive, gboolean restart)
{
	return G_WEB_ENGINE_GET_CLASS (self)->find_text (self, string, reverse, whole_word, case_sensitive, restart);
}

void
g_web_engine_authenticate (GWebEngine *self, gboolean ok, const gchar *username, const gchar *password)
{
	G_WEB_ENGINE_GET_CLASS (self)->authenticate (self, ok, username, password);
}

GWebStatus
g_web_engine_cut (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->cut (self);
}

GWebStatus
g_web_engine_copy (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->copy (self);
}

GWebStatus
g_web_engine_paste (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->paste (self);
}

gboolean
g_web_engine_can_cut (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->can_cut (self);
}

gboolean
g_web_engine_can_paste (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->can_paste (self);
}

gboolean
g_web_engine_can_copy (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->can_copy (self);
}

gboolean
g_web_engine_can_selecttext (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->can_selecttext (self);
}

gchar*
g_web_engine_get_favicon_name (GWebEngine *self, const gchar *favicon_folder)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_favicon_name (self, favicon_folder);
}

GObject*
g_web_engine_get_engine_widget (GWebEngine *self)
{
	return G_WEB_ENGINE_GET_CLASS (self)->get_engine_widget (self);
}

void
g_web_engine_set_open_link_mode (GWebEngine *self, gboolean in_new_window)
{
	G_WEB_ENGINE_GET_CLASS (self)->set_open_link_mode (self, in_new_window);
}

GWebStatus
g_web_engine_set_true_zoom_mode (GWebEngine *self, gboolean status)
{
	return G_WEB_ENGINE_GET_CLASS (self)->set_true_zoom_mode (self, status);
}

void
g_web_engine_notify_plugins (GWebEngine *self, gint event)
{
	G_WEB_ENGINE_GET_CLASS (self)->notify_plugins (self, event);
}

void
g_web_engine_preload_current_skin (GWebEngine *self)
{
	G_WEB_ENGINE_GET_CLASS (self)->preload_current_skin (self);
}
