/**
  * Web Engine Abstraction Layer.
  * @file gwebtransferitemlist.h: Transfer Item List Interface Declaration
  * @version $Rev: 2092 $
  * @date $LastChangedDate: 2005-11-01 14:53:00 +0200 (Tue, 01 Nov 2005) $
  *
  * Copyright (C) 2005 Nokia Corporation.
  *
  * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public License
  * as published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA
  *
  */

#include <glib-object.h>

#ifndef __GWEBTRANSFERITEMLIST_H__
#define __GWEBTRANSFERITEMLIST_H__

G_BEGIN_DECLS

/** GWebTransferItemList
  */

#define G_TYPE_WEB_TRANSFER_ITEM_LIST             (g_web_transfer_item_get_type ())
#define G_WEB_TRANSFER_ITEM_LIST(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_WEB_TRANSFER_ITEM_LIST, GWebTransferItemList))
#define G_WEB_TRANSFER_ITEM_LIST_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_WEB_TRANSFER_ITEM_LIST, GWebTransferItemListIface))
#define G_IS_WEB_TRANSFER_ITEM_LIST(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_WEB_TRANSFER_ITEM_LIST))
#define G_IS_WEB_TRANSFER_ITEM_LIST_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_WEB_TRANSFER_ITEM_LIST))
#define G_WEB_TRANSFER_ITEM_LIST_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_WEB_TRANSFER_ITEM_LIST, GWebTransferItemListIface))

typedef struct _GWebTransferItemList GWebTransferItemList; /* dummy object */
typedef struct _GWebTransferItemListIface GWebTransferItemListIface;

/** @struct GWebTransferItemListIface.
  * Defines web transfer item list interface.
  */
struct _GWebTransferItemListIface {
	GTypeInterface parent;

	void (*destroy) (GWebTransferItemList *self);
	GObject** (*get_items) (GWebTransferItemList *self);
	gint (*get_items_count) (GWebTransferItemList *self);
};

GType g_web_transfer_item_list_get_type (void);

void g_web_transfer_item_list_destroy (GWebTransferItemList *self);
GObject** g_web_transfer_item_list_get_items (GWebTransferItemList *self);
gint g_web_transfer_item_list_get_items_count (GWebTransferItemList *self);

G_END_DECLS

#endif /* __GWEBTRANSFERITEMLIST_H__ */
