/**
  * Web Engine Abstraction Layer.
  * @file gwebpluginlist.h: Plugin List Interface Declaration
  * @version $Rev: 2092 $
  * @date $LastChangedDate: 2005-11-01 14:53:00 +0200 (Tue, 01 Nov 2005) $
  *
  * Copyright (C) 2005 Nokia Corporation.
  *
  * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public License
  * as published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA
  *
  */

#include <glib-object.h>

#ifndef __GWEBPLUGINLIST_H__
#define __GWEBPLUGINLIST_H__

G_BEGIN_DECLS

/** GWebPluginList
  */

#define G_TYPE_WEB_PLUGIN_LIST             (g_web_plugin_list_get_type ())
#define G_WEB_PLUGIN_LIST(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_WEB_PLUGIN_LIST, GWebPluginList))
#define G_WEB_PLUGIN_LIST_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_WEB_PLUGIN_LIST, GWebPluginListIface))
#define G_IS_WEB_PLUGIN_LIST(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_WEB_PLUGIN_LIST))
#define G_IS_WEB_PLUGIN_LIST_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_WEB_PLUGIN_LIST))
#define G_WEB_PLUGIN_LIST_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_WEB_PLUGIN_LIST, GWebPluginListIface))

typedef struct _GWebPluginList GWebPluginList; /* dummy object */
typedef struct _GWebPluginListIface GWebPluginListIface;

/** @struct GWebPluginListIface.
  * Defines web plugin list interface.
  */
struct _GWebPluginListIface {
	GTypeInterface parent;

	void (*destroy) (GWebPluginList *self);
	GObject* (*get_items) (GWebPluginList *self);
	gint (*get_items_count) (GWebPluginList *self);
	const gchar* (*get_item_title) (GWebPluginList *self, gint pos);
	const gchar* (*get_item_path) (GWebPluginList *self, gint pos);
	const gchar* (*get_item_type) (GWebPluginList *self, gint pos);
};

GType g_web_plugin_list_get_type (void);

void g_web_plugin_list_destroy (GWebPluginList *self);
GObject* g_web_plugin_list_get_items (GWebPluginList *self);
gint g_web_plugin_list_get_items_count (GWebPluginList *self);
const gchar* g_web_plugin_list_get_item_title (GWebPluginList *self, gint pos);
const gchar* g_web_plugin_list_get_item_path (GWebPluginList *self, gint pos);
const gchar* g_web_plugin_list_get_item_type (GWebPluginList *self, gint pos);

G_END_DECLS

#endif /* __GWEBPLUGINLIST_H__ */
