/**
  * Web Engine Abstraction Layer.
  * @file gwebpassman.h: Password Manager Interface Declarations
  * @version $Rev: 2092 $
  * @date $LastChangedDate: 2005-11-01 14:53:00 +0200 (Tue, 01 Nov 2005) $
  *
  * Copyright (C) 2005 Nokia Corporation.
  *
  * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public License
  * as published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA
  *
  */

#include <glib-object.h>
#include "gwebcommon.h"

#ifndef __GWEBPASSMAN_H__
#define __GWEBPASSMAN_H__

G_BEGIN_DECLS

#define G_TYPE_WEB_PASSWORD_MANAGER             (g_web_password_manager_get_type())
#define G_WEB_PASSWORD_MANAGER(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj), G_TYPE_WEB_PASSWORD_MANAGER, GWebPasswordManager))
#define G_WEB_PASSWORD_MANAGER_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST((vtable), G_TYPE_WEB_PASSWORD_MANAGER, GWebPasswordManagerIface))
#define G_IS_WEB_PASSWORD_MANAGER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj), G_TYPE_WEB_PASSWORD_MANAGER))
#define G_IS_WEB_PASSWORD_MANAGER_CLASS(vtable)    (G_TYPE_CHECK_CLASS_TYPE((vatable), G_TYPE_WEB_PASSWORD_MANAGER))
#define G_WEB_PASSWORD_MANAGER_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE((inst), G_TYPE_WEB_PASSWORD_MANAGER, GWebPasswordManagerIface))

typedef struct _GWebPasswordManager      GWebPasswordManager;
typedef struct _GWebPasswordManagerIface  GWebPasswordManagerIface;

struct _GWebPasswordManagerIface
{
	GTypeInterface parent;
	
	GWebStatus (*get_login_username) (GWebPasswordManager *self, gchar** username);
	GWebStatus (*get_login_password) (GWebPasswordManager *self, gchar** password);
	GObject* (*login_get_personal_data) (GWebPasswordManager *self);
};

GType      g_web_password_manager_get_type         (void);

/**
  * Get the username from a GWebPasswordManager.
  * attention The string must be freed using g_free().
  *
  * @param self Object Pointer.
  * @param username Return argument for the username.
  *
  * @return @c G_WEB_STATUS_OK on success.
  */
GWebStatus g_web_password_manager_get_login_username(GWebPasswordManager *self, gchar** username);

/**
  * Get the password from a GWebPasswordManager..
  * attention The string must be freed using g_free().
  *
  * @param self Object Pointer.
  * @param password Return argument for the password.
  *
  * @return @c G_WEB_STATUS_OK on success.
  */
GWebStatus g_web_password_manager_get_login_password(GWebPasswordManager *self, gchar** password);

/**
  * Get the personal data that is stored for a server.
  *
  * @param self Object Pointer.
  * @return Returns the personal data.
  */
GObject* g_web_password_manager_login_get_personal_data(GWebPasswordManager *self);

G_END_DECLS

#endif //__GWEBPASSMAN_H__
