/**
  * Web Engine Abstraction Layer.
  * @file gwebhistorylist.h: History List Interface Declaration
  * @version $Rev: 2092 $
  * @date $LastChangedDate: 2005-11-01 14:53:00 +0200 (Tue, 01 Nov 2005) $
  *
  * Copyright (C) 2005 Nokia Corporation.
  *
  * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public License
  * as published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA
  *
  */

#include <glib-object.h>

#ifndef __GWEBHISTORYLIST_H__
#define __GWEBHISTORYLIST_H__

G_BEGIN_DECLS

/** GWebHistoryList
  */

#define G_TYPE_WEB_HISTORY_LIST             (g_web_history_list_get_type ())
#define G_WEB_HISTORY_LIST(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_WEB_HISTORY_LIST, GWebHistoryList))
#define G_WEB_HISTORY_LIST_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_WEB_HISTORY_LIST, GWebHistoryListIface))
#define G_IS_WEB_HISTORY_LIST(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_WEB_HISTORY_LIST))
#define G_IS_WEB_HISTORY_LIST_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_WEB_HISTORY_LIST))
#define G_WEB_HISTORY_LIST_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_WEB_HISTORY_LIST, GWebHistoryListIface))

typedef struct _GWebHistoryList GWebHistoryList; /* dummy object */
typedef struct _GWebHistoryListIface GWebHistoryListIface;

/** @struct GWebHistoryListIface.
  * Defines web history list interface.
  */
struct _GWebHistoryListIface {
	GTypeInterface parent;

	void (*destroy) (GWebHistoryList *self);
	void (*delete_item) (GWebHistoryList *self, GObject *item);
	GObject* (*get_items) (GWebHistoryList *self);
	gint (*get_items_count) (GWebHistoryList *self);
	const gchar* (*get_item_title) (GWebHistoryList *self, gint pos);
	const gchar* (*get_item_url) (GWebHistoryList *self, gint pos);
	GTime (*get_item_time) (GWebHistoryList *self, gint pos);
};

GType g_web_history_list_get_type (void);

void g_web_history_list_destroy (GWebHistoryList *self);
void g_web_history_list_delete_item (GWebHistoryList *self, GObject *item);
GObject* g_web_history_list_get_items (GWebHistoryList *self);
gint g_web_history_list_get_items_count (GWebHistoryList *self);
const gchar* g_web_history_list_get_item_title (GWebHistoryList *self, gint pos);
const gchar* g_web_history_list_get_item_url (GWebHistoryList *self, gint pos);
GTime g_web_history_list_get_item_time (GWebHistoryList *self, gint pos);

G_END_DECLS

#endif /* __GWEBHISTORYLIST_H__ */
