#!/bin/sh -e
#
# Valgrind wrapper

# Default Debian debug libraries.
DBGPATH=/usr/lib/debug:/usr/X11R6/lib/debug

# Use memcheck as the default tool.
if [ -z "$VALGRIND_OPTS" ]; then
	export VALGRIND_OPTS="--tool=memcheck"
fi

# Use debug libraries if found.
if [ -z "$LD_LIBRARY_PATH" ]; then
	export LD_LIBRARY_PATH=$DBGPATH
else
	export LD_LIBRARY_PATH=$DBGPATH:$LD_LIBRARY_PATH
fi

# Use 'exec' to avoid having another shell process hanging around.
exec $0.bin "$@"

