/*
 * This file is part of hildon-fm package
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "osso-thumbnail-factory.h"
#include "osso-thumber-common.h"

#include <stdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

//void resize(int a, int b, int x, int y) {
GdkPixbuf *crop_resize(GdkPixbuf *src, int width, int height) {
    int x = width, y = height;
    int a = gdk_pixbuf_get_width(src);
    int b = gdk_pixbuf_get_height(src);

    GdkPixbuf *dest;

    int nx, ny;
    double na, nb;
    double offx = 0, offy = 0;
    double scax, scay;

    na = a;
    nb = b;

    if(a < x && b < y) {
        //nx = a;
        //ny = b;
        g_object_ref(src);
        return src;
    } else {
        int u, v;

        nx = u = x;
        ny = v = y;

        if(a < x) {
            nx = a;
            u = a;
        }

        if(b < y) {
            ny = b;
            v = b;
        }

        //printf("na=%f, nb=%f, nx=%d, ny=%d, u=%d, v=%d\n", na, nb, nx, ny, u, v);

        if(a * y < b * x) {
            nb = (double)a * v / u;
            // Center
            offy = (double)(b - nb) / 2;
        } else {
            na = (double)b * u / v;
            // Center
            offx = (double)(a - na) / 2;
        }
    }

    // gdk_pixbuf_scale has crappy inputs
    scax = scay = (double)nx / na;

    offx = -offx * scax;
    offy = -offy * scay;

    /*
    printf("(%d, %d) -> (%d, %d) => (%f, %f) -> (%d, %d)\n",
        a, b, x, y, na, nb, nx, ny);
    printf("offx=%f, offy=%f, scax=%f, scay=%f\n",
        offx, offy, scax, scay);
    */

    dest = gdk_pixbuf_new(gdk_pixbuf_get_colorspace(src),
        gdk_pixbuf_get_has_alpha(src), gdk_pixbuf_get_bits_per_sample(src),
        nx, ny);

    gdk_pixbuf_scale(src, dest, 0, 0, nx, ny, offx, offy, scax, scay,
        GDK_INTERP_BILINEAR);

    return dest;
}

GdkPixbuf *create_thumb(const gchar *local_file, const gchar *mime_type,
    guint width, guint height, OssoThumbnailFlags flags,
    gchar ***opt_keys, gchar ***opt_values, GError **error)
{
    if(flags & OSSO_THUMBNAIL_FLAG_CROP) {
        GdkPixbuf *pixbuf = gdk_pixbuf_new_from_file(local_file, NULL);
        if(pixbuf) {
            GdkPixbuf *res = crop_resize(pixbuf, width, height);
            g_object_unref(pixbuf);
            return res;
        } else {
            return NULL;
        }
    } else {
        return gdk_pixbuf_new_from_file_at_size(local_file, width, height, NULL);
    }
}

int main(int argc, char **argv)
{
    return osso_thumber_main(&argc, &argv, create_thumb);
}
