/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*----------Creation of the controls for testing the widget-----------*/
void create_second_window()
{
	s_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect(G_OBJECT(s_window),"destroy",G_CALLBACK(back_callback),NULL);

	vbox1=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(s_window),vbox1);
	
	hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox1),hbox1,FALSE,FALSE,0);
	
	set_day=gtk_combo_box_new_text();

        gtk_combo_box_insert_text(GTK_COMBO_BOX(set_day),0,"Monday");
        gtk_combo_box_insert_text(GTK_COMBO_BOX(set_day),1,"Tuesday");
        gtk_combo_box_insert_text(GTK_COMBO_BOX(set_day),2,"Wednesday");
        gtk_combo_box_insert_text(GTK_COMBO_BOX(set_day),3,"Thursday");
        gtk_combo_box_insert_text(GTK_COMBO_BOX(set_day),4,"Friday");
        gtk_combo_box_insert_text(GTK_COMBO_BOX(set_day),5,"Saturday");
        gtk_combo_box_insert_text(GTK_COMBO_BOX(set_day),6,"Sunday");

        gtk_combo_box_set_active(GTK_COMBO_BOX(set_day),0);
	gtk_box_pack_start(GTK_BOX(hbox1),set_day,FALSE,FALSE,0);

        /*------------------Set Button------------------------*/

	hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox1),hbox1,FALSE,FALSE,0);
	
        set_button=gtk_button_new_with_label("   SET   ");
	gtk_box_pack_start(GTK_BOX(hbox1),set_button,TRUE,TRUE,5);
	
        unset_button=gtk_button_new_with_label("  UNSET  ");
	gtk_box_pack_start(GTK_BOX(hbox1),unset_button,TRUE,TRUE,5);
	
        toggle_button=gtk_toggle_button_new_with_label(" TOGGLE ");
	gtk_box_pack_start(GTK_BOX(hbox1),toggle_button,TRUE,TRUE,5);
	
	hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox1),hbox1,FALSE,FALSE,0);
	
        isset_button=gtk_button_new_with_label("  IS SET..?  ");
	gtk_box_pack_start(GTK_BOX(hbox1),isset_button,TRUE,TRUE,5);
	
        result=gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(hbox1),result,TRUE,TRUE,5);
	
	hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox1),hbox1,FALSE,FALSE,0);
	
        set_all=gtk_button_new_with_label("    SET ALL    ");
	gtk_box_pack_start(GTK_BOX(hbox1),set_all,TRUE,TRUE,5);
	
        unset_all=gtk_button_new_with_label("  UNSET ALL  ");
	gtk_box_pack_start(GTK_BOX(hbox1),unset_all,TRUE,TRUE,5);
	
	back_button=gtk_button_new_with_label("   Back   ");
	gtk_box_pack_end(GTK_BOX(vbox1),back_button,FALSE,FALSE,0);

	/*------------------------------Signal Handlers-------------------------------*/
        g_signal_connect(G_OBJECT(set_button),"clicked",G_CALLBACK(set_day_callback),NULL);
	g_signal_connect(G_OBJECT(unset_button),"clicked",G_CALLBACK(unset_day_callback),NULL);
	g_signal_connect(G_OBJECT(toggle_button),"toggled",G_CALLBACK(toggle_day_callback),NULL);
	g_signal_connect(G_OBJECT(isset_button),"clicked",G_CALLBACK(isset_callback),NULL);
	g_signal_connect(G_OBJECT(back_button),"clicked",G_CALLBACK(back_callback),NULL);
	g_signal_connect(G_OBJECT(set_all),"clicked",G_CALLBACK(set_all_callback),NULL);
	g_signal_connect(G_OBJECT(unset_all),"clicked",G_CALLBACK(unset_all_callback),NULL);

}


/*------------creation of the window that displays the widget-------*/
void create_main_window (void)
{
	
	h_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect(G_OBJECT(h_window),"destroy",gtk_main_quit,NULL);
	
	vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(h_window),vbox);
	
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	create_second_window();
	
	/*------------Creating a Weekday Picker---------------*/
	h_wdpicker=hildon_weekday_picker_new();
	gtk_box_pack_start(GTK_BOX(hbox),h_wdpicker,FALSE,FALSE,0);
	
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	prop_button=gtk_button_new_from_stock(GTK_STOCK_PROPERTIES);
	gtk_box_pack_start(GTK_BOX(hbox),prop_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(prop_button),"clicked",G_CALLBACK(prop_callback),NULL);

	quit_button=gtk_button_new_from_stock(GTK_STOCK_QUIT);
	gtk_box_pack_start(GTK_BOX(hbox),quit_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);
	

        gtk_widget_show_all(h_window);
}
