/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*----Callback of properties button----*/
void prop_callback(void)
{

	gtk_widget_hide(h_window);
	gtk_widget_show_all(s_window);

}

/*-----displays the main window-----*/
void back_callback(void)
{

	gtk_widget_hide(s_window);
	gtk_widget_show(h_window);

}

/*---------	Callback of set button
 * 		Takes the value from the combo box and sets the corresponding day--------*/
void set_day_callback(GtkButton *c,gpointer user_data)
{
	gint sel;

	sel=gtk_combo_box_get_active(GTK_COMBO_BOX(set_day));

	switch(sel)
	{
		case 0: hildon_weekday_picker_set_day(h_wdpicker,G_DATE_MONDAY);
			break;
		case 1: hildon_weekday_picker_set_day(h_wdpicker,G_DATE_TUESDAY);
			break;
		case 2: hildon_weekday_picker_set_day(h_wdpicker,G_DATE_WEDNESDAY);
		        break;
		case 3: hildon_weekday_picker_set_day(h_wdpicker,G_DATE_THURSDAY);
		        break;
		case 4: hildon_weekday_picker_set_day(h_wdpicker,G_DATE_FRIDAY);
                        break;
       		case 5: hildon_weekday_picker_set_day(h_wdpicker,G_DATE_SATURDAY);
		        break;
		case 6: hildon_weekday_picker_set_day(h_wdpicker,G_DATE_SUNDAY);
                        break;
	}
	gtk_label_set_text(result,"");
	gtk_widget_hide(s_window);
	gtk_widget_show_all(h_window);
}

/*---------     Callback of unset button
 *  *              Takes the value from the combo box and unsets the corresponding day--------*/
void unset_day_callback(GtkButton *c,gpointer user_data)
{
        gint sel;

	sel=gtk_combo_box_get_active(GTK_COMBO_BOX(set_day));
        switch(sel)
        {
 	       case 0: hildon_weekday_picker_unset_day(h_wdpicker,G_DATE_MONDAY);
	               break;
	       case 1: hildon_weekday_picker_unset_day(h_wdpicker,G_DATE_TUESDAY);
	               break;
               case 2: hildon_weekday_picker_unset_day(h_wdpicker,G_DATE_WEDNESDAY);
                       break;
               case 3: hildon_weekday_picker_unset_day(h_wdpicker,G_DATE_THURSDAY);
                       break;
               case 4: hildon_weekday_picker_unset_day(h_wdpicker,G_DATE_FRIDAY);
                       break;
               case 5: hildon_weekday_picker_unset_day(h_wdpicker,G_DATE_SATURDAY);
                       break;
               case 6: hildon_weekday_picker_unset_day(h_wdpicker,G_DATE_SUNDAY);
		       break;
        }
	gtk_label_set_text(result,"");
	gtk_widget_hide(s_window);
        gtk_widget_show_all(h_window);
		
}

/*---------     Callback of toggle button
 *                Takes the value from the combo box and toggles the corresponding day--------*/
void toggle_day_callback(GtkToggleButton *t,gpointer user_data)
{
	 gint sel;

         sel=gtk_combo_box_get_active(GTK_COMBO_BOX(set_day));
         switch(sel)
         {
	         case 0: hildon_weekday_picker_toggle_day(h_wdpicker,G_DATE_MONDAY);							              break;
	         case 1: hildon_weekday_picker_toggle_day(h_wdpicker,G_DATE_TUESDAY);
	                 break;
		 case 2: hildon_weekday_picker_toggle_day(h_wdpicker,G_DATE_WEDNESDAY);
		         break;
		 case 3: hildon_weekday_picker_toggle_day(h_wdpicker,G_DATE_THURSDAY);
		         break;
		 case 4: hildon_weekday_picker_toggle_day(h_wdpicker,G_DATE_FRIDAY);
		         break;
		 case 5: hildon_weekday_picker_toggle_day(h_wdpicker,G_DATE_SATURDAY);
		         break;
		 case 6: hildon_weekday_picker_toggle_day(h_wdpicker,G_DATE_SUNDAY);
		         break;
	}
	 gtk_label_set_text(result,"");
	 gtk_widget_hide(s_window);
         gtk_widget_show_all(h_window);
		 
}

/*---------     Callback of isset button
 *              Takes the value from the combo box and checks if the corresponding day is set or not --------*/
void isset_callback(GtkButton *b,gpointer user_data)
{
	gint sel;
	GDateWeekday day;
	gboolean check;
	
	sel=gtk_combo_box_get_active(GTK_COMBO_BOX(set_day));
	switch(sel)
	{
		case 0: day=G_DATE_MONDAY;	break;
		case 1: day=G_DATE_TUESDAY;	break;
		case 2: day=G_DATE_WEDNESDAY;	break;
		case 3: day=G_DATE_THURSDAY;	break;
		case 4: day=G_DATE_FRIDAY;	break;
		case 5: day=G_DATE_SATURDAY;	break;
		case 6: day=G_DATE_SUNDAY;	break;
	}
	check=hildon_weekday_picker_isset_day(h_wdpicker,day);
	if(check)
		gtk_label_set_text(result,"Set");
	else
		gtk_label_set_text(result,"Unset");
}

/*-------Sets all the days of the week--------*/
void set_all_callback(GtkButton *b,gpointer user_data)
{
	hildon_weekday_picker_set_all(h_wdpicker);
	gtk_label_set_text(result,"");
	gtk_widget_hide(s_window);
        gtk_widget_show_all(h_window);
		
}

/*--------Unsets all the days of the week------*/
void unset_all_callback(GtkButton *b,gpointer user_data)
{
        hildon_weekday_picker_unset_all(h_wdpicker);
	gtk_label_set_text(result,"");
	gtk_widget_hide(s_window);
        gtk_widget_show_all(h_window);
		
}
