/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

int main(int argc,char *argv[])
{

	gtk_init(&argc,&argv);

	/* Create Main Window */

	main_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(main_window),10);
	gtk_window_set_title(GTK_WINDOW(main_window),"Volumebar App");
	g_signal_connect(G_OBJECT(main_window),"destroy",gtk_main_quit,NULL);

	main_vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(main_window),main_vbox);

	h_bar=gtk_button_new_with_label("Horizontal Volumebar");
	gtk_box_pack_start(GTK_BOX(main_vbox),h_bar,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(h_bar),"clicked",G_CALLBACK(open_hbar),NULL);

	v_bar=gtk_button_new_with_label("Vertical Volumebar");
	gtk_box_pack_start(GTK_BOX(main_vbox),v_bar,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(v_bar),"clicked",G_CALLBACK(open_vbar),NULL);

	quit_button=gtk_button_new_from_stock(GTK_STOCK_QUIT);
	gtk_box_pack_end(GTK_BOX(main_vbox),quit_button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);
	
	gtk_widget_show_all(main_window);

	gtk_main();
	return 0;

}

