/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"


void open_hbar(void)
{

	GtkWidget *tvbox;
	
	/* Horizontal Volumebar Implementation */
	
	hbar_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(hbar_window),10);
	gtk_window_set_title(GTK_WINDOW(hbar_window),"Horizontal Volumebar");
	g_signal_connect(G_OBJECT(hbar_window),"destroy",G_CALLBACK(hbar_home_call),NULL);

	hbar_vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(hbar_window),hbar_vbox);

	hvbar=hildon_hvolumebar_new();
	gtk_box_pack_start(GTK_BOX(hbar_vbox),hvbar,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(hvbar),"level_changed",G_CALLBACK(hlevel_change_call),NULL);

	hbar_frame=gtk_frame_new("Properties");
	gtk_box_pack_end(GTK_BOX(hbar_vbox),hbar_frame,FALSE,FALSE,0);

	tvbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(hbar_frame),tvbox);

	hbar_entry=gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(hbar_entry),5);
	gtk_box_pack_start(GTK_BOX(tvbox),hbar_entry,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(hbar_entry),"key-press-event",G_CALLBACK(entry_key_pressed),NULL);

	hbar_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(tvbox),hbar_hbox,FALSE,FALSE,0);
	
	hbar_combo=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(hbar_combo),"Level");
	gtk_combo_box_append_text(GTK_COMBO_BOX(hbar_combo),"Mute");
	gtk_combo_box_append_text(GTK_COMBO_BOX(hbar_combo),"Change Level to default(67)");
	gtk_combo_box_set_active(GTK_COMBO_BOX(hbar_combo),0);
	gtk_box_pack_start(GTK_BOX(hbar_hbox),hbar_combo,TRUE,TRUE,5);

	hbar_set=gtk_button_new_with_label("Set");
	gtk_box_pack_start(GTK_BOX(hbar_hbox),hbar_set,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(hbar_set),"clicked",G_CALLBACK(hbar_set_call),NULL);
	
	hbar_get=gtk_button_new_with_label("Get");
	gtk_box_pack_start(GTK_BOX(hbar_hbox),hbar_get,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(hbar_get),"clicked",G_CALLBACK(hbar_get_call),NULL);
			
	hbar_home=gtk_button_new_from_stock(GTK_STOCK_HOME);
	gtk_box_pack_start(GTK_BOX(tvbox),hbar_home,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(hbar_home),"clicked",G_CALLBACK(hbar_home_call),NULL);

	gtk_widget_show_all(hbar_window);

}
	
void open_vbar(void)
{

	GtkWidget *tvbox;
	
	/* Vertical Volumebar Implementation */
	
	vbar_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(vbar_window),10);
	gtk_window_set_title(GTK_WINDOW(vbar_window),"Horizontal Volumebar");
	g_signal_connect(G_OBJECT(vbar_window),"destroy",G_CALLBACK(vbar_home_call),NULL);

	vbar_vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(vbar_window),vbar_vbox);

	vvbar=hildon_vvolumebar_new();
	gtk_box_pack_start(GTK_BOX(vbar_vbox),vvbar,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(vvbar),"level_changed",G_CALLBACK(vlevel_change_call),NULL);

	vbar_frame=gtk_frame_new("Properties");
	gtk_box_pack_end(GTK_BOX(vbar_vbox),vbar_frame,FALSE,FALSE,0);

	tvbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(vbar_frame),tvbox);


	vbar_entry=gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(vbar_entry),5);
	gtk_box_pack_start(GTK_BOX(tvbox),vbar_entry,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(vbar_entry),"key-press-event",G_CALLBACK(entry_key_pressed),NULL);

	vbar_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(tvbox),vbar_hbox,FALSE,FALSE,0);
	
	vbar_combo=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(vbar_combo),"Level");
	gtk_combo_box_append_text(GTK_COMBO_BOX(vbar_combo),"Mute");
	gtk_combo_box_append_text(GTK_COMBO_BOX(vbar_combo),"Change Level to default(45)");
	gtk_combo_box_set_active(GTK_COMBO_BOX(vbar_combo),0);
	gtk_box_pack_start(GTK_BOX(vbar_hbox),vbar_combo,TRUE,TRUE,5);

	vbar_set=gtk_button_new_with_label("Set");
	gtk_box_pack_start(GTK_BOX(vbar_hbox),vbar_set,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(vbar_set),"clicked",G_CALLBACK(vbar_set_call),NULL);
	
	vbar_get=gtk_button_new_with_label("Get");
	gtk_box_pack_start(GTK_BOX(vbar_hbox),vbar_get,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(vbar_get),"clicked",G_CALLBACK(vbar_get_call),NULL);

	vbar_home=gtk_button_new_from_stock(GTK_STOCK_HOME);
	gtk_box_pack_start(GTK_BOX(tvbox),vbar_home,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(vbar_home),"clicked",G_CALLBACK(vbar_home_call),NULL);
	
	gtk_widget_show_all(vbar_window);

}

