/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

void hbar_set_call(void)
{

	gint res;
	static val=3;
	double level;

	res=gtk_combo_box_get_active(GTK_COMBO_BOX(hbar_combo));
	switch(res)
	{

		case 0 : level=atoi(gtk_entry_get_text(GTK_ENTRY(hbar_entry)));
			 if(level>100.0 || level<0.0)
			 {
				 gtk_infoprint(GTK_WINDOW(hbar_window),"Val>=0.0&&<=100.0");
				 break;
			 }
			 hildon_volumebar_set_level(HILDON_VOLUMEBAR(hvbar),level);
			 break;

		case 1 : hildon_volumebar_set_mute(HILDON_VOLUMEBAR(hvbar),(val++)%2);
			 break;

		case 2 : htest=TRUE;
			 hildon_volumebar_level_change(HILDON_VOLUMEBAR(hvbar));
			 break;

	}

	if(val>7)
		val=3;
			 

}

void hbar_get_call(void)
{

	gint res;
	gboolean mute;
	double level;
	gchar str[30];

	res=gtk_combo_box_get_active(GTK_COMBO_BOX(hbar_combo));
	switch(res)
	{

		case 0 : level=hildon_volumebar_get_level(HILDON_VOLUMEBAR(hvbar));
			 sprintf(str,"%f",level);
			 gtk_entry_set_text(GTK_ENTRY(hbar_entry),str);
			 break;

		case 1 : mute=hildon_volumebar_get_mute(HILDON_VOLUMEBAR(hvbar));
			 if(mute)
				 gtk_entry_set_text(GTK_ENTRY(hbar_entry),"ON");
			 else
				 gtk_entry_set_text(GTK_ENTRY(hbar_entry),"OFF");
			 break;
 
	}

}

void hlevel_change_call(void)
{

	double level,level1=67.0;
	gchar str[30];
	
	if(htest==TRUE)
	{
		htest=FALSE;
		hildon_volumebar_set_level(HILDON_VOLUMEBAR(hvbar),level1);
	}
	level=hildon_volumebar_get_level(HILDON_VOLUMEBAR(hvbar));
	sprintf(str,"%f",level);
	gtk_entry_set_text(GTK_ENTRY(hbar_entry),str);

}

void hbar_home_call(void)
{

	gtk_widget_hide(hbar_window);
	gtk_widget_show(main_window);

}


void vbar_set_call(void)
{

	gint res;
	static val=3;
	double level;

	res=gtk_combo_box_get_active(GTK_COMBO_BOX(vbar_combo));
	switch(res)
	{

		case 0 : level=atoi(gtk_entry_get_text(GTK_ENTRY(vbar_entry)));
			 if(level>100.0 || level<0.0)
			 {
				 gtk_infoprint(GTK_WINDOW(vbar_window),"Val>=0.0&&<=100.0");
				 break;
			 }
			 hildon_volumebar_set_level(HILDON_VOLUMEBAR(vvbar),level);
			 break;

		case 1 : hildon_volumebar_set_mute(HILDON_VOLUMEBAR(vvbar),(val++)%2);
			 break;

		case 2 : vtest=TRUE;
			 hildon_volumebar_level_change(HILDON_VOLUMEBAR(vvbar));
			 break;
				 

	}

	if(val>7)
		val=3;
			 

}

void vbar_get_call(void)
{

	gint res;
	gboolean mute;
	double level;
	gchar str[30];

	res=gtk_combo_box_get_active(GTK_COMBO_BOX(vbar_combo));
	switch(res)
	{

		case 0 : level=hildon_volumebar_get_level(HILDON_VOLUMEBAR(vvbar));
			 sprintf(str,"%f",level);
			 gtk_entry_set_text(GTK_ENTRY(vbar_entry),str);
			 break;

		case 1 : mute=hildon_volumebar_get_mute(HILDON_VOLUMEBAR(vvbar));
			 if(mute)
				 gtk_entry_set_text(GTK_ENTRY(vbar_entry),"ON");
			 else
				 gtk_entry_set_text(GTK_ENTRY(vbar_entry),"OFF");
			 break;
 
	}

}


void vlevel_change_call(void)
{

	double level,level1=45.0;
	gchar str[30];
	
	if(vtest==TRUE)
	{
		vtest=FALSE;
		hildon_volumebar_set_level(HILDON_VOLUMEBAR(vvbar),level1);
	}
	level=hildon_volumebar_get_level(HILDON_VOLUMEBAR(vvbar));
	sprintf(str,"%f",level);
	gtk_entry_set_text(GTK_ENTRY(vbar_entry),str);

}

void vbar_home_call(void)
{

	gtk_widget_hide(vbar_window);
	gtk_widget_show(main_window);

}


gboolean entry_key_pressed(GtkWidget *widget,GdkEventKey *event,gpointer data)
{

	if ((isdigit((char) event->keyval))||(event->keyval == GDK_BackSpace)||
        	(event->keyval == GDK_Left)||(event->keyval == GDK_Right)||
                (event->keyval == GDK_Up)||(event->keyval == GDK_Down)||
                (event->keyval == GDK_End)||(event->keyval == GDK_Home)||
                (event->keyval == GDK_Delete)||(event->keyval == GDK_KP_0)||
                (event->keyval == GDK_KP_1)||(event->keyval == GDK_KP_2)||
                (event->keyval == GDK_KP_3)||(event->keyval == GDK_KP_4)||
		(event->keyval == GDK_KP_5)||(event->keyval == GDK_KP_6)||
		(event->keyval == GDK_KP_7)||(event->keyval == GDK_KP_8)||
		(event->keyval == GDK_KP_9))
	        return FALSE;
	else
	        return TRUE;
}

