/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

//Creates the main window
void create_main_window()
{
	       window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	       gtk_container_set_border_width(GTK_WINDOW(window), 10);
	       vbox1=gtk_vbox_new(FALSE, 20);
	       hbox1=gtk_hbox_new(FALSE, 10);
	       hbox2=gtk_hbox_new(FALSE, 0);
	       hbox3=gtk_hbox_new(FALSE, 0);
	       hbox4=gtk_hbox_new(FALSE, 10);
		       

	       frame=gtk_frame_new(" ");
	       gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
	       gtk_frame_set_label_align(GTK_FRAME(frame), 0.5, 0.5);
	       gtk_container_add(GTK_CONTAINER(window), frame);
	      
	       align=gtk_alignment_new(0.5, 0.5, 0, 0);
	       Blaunch=gtk_button_new_with_label("Launch Time Picker");
	       gtk_widget_set_usize(GTK_WIDGET(Blaunch), 250, 40);
	       gtk_container_add(GTK_CONTAINER(align), Blaunch);
	       gtk_box_pack_start(GTK_BOX(vbox1), align, FALSE, 0, 0);
	       
	       hsep1=gtk_hseparator_new();
	       gtk_box_pack_start(GTK_BOX(vbox1), hsep1, FALSE, 0, 0);

	       Lset=gtk_label_new("Set Time:");
	       gtk_box_pack_start(GTK_BOX(hbox2), Lset, FALSE, 0, 0);
	       gtk_box_pack_start(GTK_BOX(vbox1), hbox2, FALSE, 0, 0);
			       
	       Lhour=gtk_label_new("Hour:");
	       gtk_box_pack_start(GTK_BOX(hbox1), Lhour, FALSE, 0, 0);

	       Ehour=gtk_entry_new();
	       gtk_box_pack_start(GTK_BOX(hbox1), Ehour, FALSE, 0, 0);
	       
	       Lmin=gtk_label_new("Mins:");
               gtk_box_pack_start(GTK_BOX(hbox1), Lmin, FALSE, 0, 0);
			                                                                                                         
               Emin=gtk_entry_new();
               gtk_box_pack_start(GTK_BOX(hbox1), Emin, FALSE, 0, 0);

	       Bset=gtk_button_new_with_label("Set");
	       gtk_widget_set_usize(Bset, 110, 40);
	       gtk_widget_set_sensitive(Bset, FALSE);
	       gtk_box_pack_start(GTK_BOX(hbox1), Bset, FALSE, 0, 0);
	       
	       
	       Lget=gtk_label_new("Get Time:");
	       gtk_box_pack_start(GTK_BOX(hbox3), Lget, FALSE, 0, 0);
	       
	       Bget=gtk_button_new_with_label("Get");
	       gtk_widget_set_usize(Bget, 110, 40);
	       gtk_box_pack_start(GTK_BOX(hbox4), Bget, FALSE, 0, 0);
	       gtk_widget_set_sensitive(Bget, FALSE);

	       Lhour1=gtk_label_new("Hour:");  
	       gtk_box_pack_start(GTK_BOX(hbox4), Lhour1, FALSE, 0, 0);
	       
	       Ehr=gtk_entry_new();
	       gtk_widget_set_sensitive(GTK_WIDGET(Ehr), FALSE);
	       gtk_box_pack_start(GTK_BOX(hbox4), Ehr, FALSE, 0, 0);

	       Lmin1=gtk_label_new("Mins:");
	       gtk_box_pack_start(GTK_BOX(hbox4), Lmin1, FALSE, 0, 0);
	       
	       Em=gtk_entry_new();
	       gtk_widget_set_sensitive(GTK_WIDGET(Em), FALSE);
	       gtk_box_pack_start(GTK_BOX(hbox4), Em, FALSE, 0, 0);

	       Bexit=gtk_button_new_with_label("Exit");
	       align=gtk_alignment_new(0.5, 0.5, 0, 0);
	       gtk_widget_set_usize(GTK_WIDGET(Bexit), 250, 40);
	       gtk_container_add(GTK_CONTAINER(align), Bexit);

	       //create second window
	       displaywindow();

	       gtk_box_pack_start(GTK_BOX(vbox1), hbox1, FALSE, 0, 0);
	       gtk_box_pack_start(GTK_BOX(vbox1), hbox3, FALSE, 0, 0);
	       gtk_box_pack_start(GTK_BOX(vbox1), hbox4, FALSE, 0, 0);
	       hsep2=gtk_hseparator_new();
	       gtk_box_pack_start(GTK_BOX(vbox1), hsep2, FALSE, 0, 0);
	       gtk_box_pack_start(GTK_BOX(vbox1), align, FALSE, 0, 0);
	       
	       /*--------------------------Signal Handlers---------------------------------------*/		
	       gtk_container_add(GTK_CONTAINER(frame), vbox1); 
	       gtk_signal_connect(GTK_OBJECT(Blaunch), "clicked", GTK_SIGNAL_FUNC(on_launch),NULL);
	       gtk_signal_connect(GTK_OBJECT(Bset), "clicked", GTK_SIGNAL_FUNC(on_set), NULL);
	       gtk_signal_connect(GTK_OBJECT(Bget), "clicked", GTK_SIGNAL_FUNC(on_get), NULL);
	       gtk_signal_connect(GTK_OBJECT(Bexit), "clicked", gtk_main_quit, NULL);
	       gtk_widget_show_all(window);
	       
}



