/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

//Creates the second window to display the time picker
void displaywindow()
{
	display_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(display_window), 10);
	d_vbox=gtk_vbox_new(FALSE,0);
	d_hbox=gtk_hbox_new(FALSE,0);
	back_button=gtk_button_new_with_label("Back");
	g_signal_connect(G_OBJECT(back_button),"clicked",G_CALLBACK(on_back),NULL);
	gtk_box_pack_end(GTK_BOX(d_vbox),d_hbox,FALSE,FALSE,FALSE);
	gtk_box_pack_start(GTK_BOX(d_hbox),back_button,TRUE,FALSE,FALSE);
	gtk_container_add(GTK_WINDOW(display_window),d_vbox);
	//gtk_widget_show_all(display_window);
}
	
//Action on clicking 'Launch Time picker' button
void on_launch(GtkWidget *button, gpointer data)
{
	gint i;
//	displaywindow();
	gtk_widget_show_all(display_window);
	time_picker=hildon_time_picker_new (NULL);
	hildon_time_picker_set_time(HILDON_TIME_PICKER(time_picker), 10, 10);
	i=gtk_dialog_run(GTK_DIALOG(time_picker));
	gtk_widget_show(time_picker);
	gtk_widget_set_sensitive(Bset, TRUE);
	gtk_widget_set_sensitive(Bget, TRUE);
	if(i==GTK_RESPONSE_OK || i==GTK_RESPONSE_ACCEPT)
	{
		gtk_widget_hide(time_picker);
		gtk_widget_hide(display_window);
		gtk_widget_show(window);
	}
	gtk_widget_hide(time_picker);
	
}

//Action on clicking 'Set' button 
void on_set(GtkWidget *button, gpointer data)
{
	gint i;
	hour=gtk_entry_get_text(GTK_ENTRY(Ehour));
	int_hours=atoi(hour);
	minutes=gtk_entry_get_text(GTK_ENTRY(Emin));
        int_minutes=atoi(minutes);
		gtk_widget_hide(window);
		gtk_widget_show(display_window);
		gtk_widget_show(time_picker);
		hildon_time_picker_set_time(HILDON_TIME_PICKER(time_picker), int_hours, int_minutes);
		i=gtk_dialog_run(GTK_DIALOG(time_picker));
		if(i==GTK_RESPONSE_OK)
		{
			gtk_widget_hide(time_picker);
			gtk_widget_hide(display_window);
			gtk_widget_show(window);
		}
		if(i == GTK_RESPONSE_CANCEL)
		{
			gtk_widget_destroy(time_picker);
                        gtk_widget_hide(display_window);
                        gtk_widget_show(window);
		}

}

//Action on clicking 'Get' button
void on_get(GtkWidget *button, gpointer data)
{
	guint *p_hours;
	guint *p_minutes;
	gchar str_h[10];
	gchar str_m[10];
	hildon_time_picker_get_time(HILDON_TIME_PICKER(time_picker), &p_hours, &p_minutes);
	sprintf(str_h, "%i", p_hours);
	sprintf(str_m, "%i", p_minutes);
	gtk_entry_set_text(GTK_ENTRY(Ehr),str_h); 
	gtk_entry_set_text(GTK_ENTRY(Em), str_m);
}

//Action on clicking "Back" buttn
void on_back(GtkWidget *button,gpointer data)
{
	gtk_widget_hide(display_window);
	gtk_widget_show(window);
}
