/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*-------Displays the widget window-------*/
void on_return(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(h_window);
	gtk_widget_show(window);
}

/*----------Creates the window with the widget to be tested-------*/
void first_window()
{
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	h_t_editor=hildon_time_editor_new();
        hildon_time_editor_set_time(h_t_editor,10,10,10);
		                                                                                                   
	vbox1=gtk_vbox_new(FALSE, 80);
	hbox6=gtk_hbox_new(FALSE, 0);
	hbox7=gtk_hbox_new(FALSE, 0);
	
	align=gtk_alignment_new(0.5, 0.5, 0, 0);
	gtk_container_add(GTK_CONTAINER(align), h_t_editor);
	gtk_box_pack_start(GTK_BOX(hbox7), align, TRUE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox7, FALSE, 0, 80);
	
	Bproperties=gtk_button_new_with_label("Properties");
	gtk_widget_set_usize(Bproperties, 150, 40);
	gtk_box_pack_start(GTK_BOX(hbox6), Bproperties, FALSE, 0, 0);

	Bx=gtk_button_new_with_label("Exit");
        gtk_widget_set_usize(Bx, 150, 40);
        gtk_box_pack_end(GTK_BOX(hbox6), Bx, FALSE, 0, 0);

	/*----------This will create the properties page-------------*/
	create_main_window();

	gtk_box_pack_end(GTK_BOX(vbox1), hbox6, FALSE, 0, 30);
	gtk_container_add(GTK_CONTAINER(window), vbox1);
	gtk_signal_connect(GTK_OBJECT(Bx), "clicked", gtk_main_quit, NULL);
	gtk_signal_connect(GTK_OBJECT(Bproperties),"clicked",  GTK_SIGNAL_FUNC(properties_call), NULL);
	
	gtk_widget_show_all(window);
	
}

/*-----------This creates the controls to test the widget---------*/
void create_main_window (void)
{
	h_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	vbox=gtk_vbox_new(FALSE,0);
	hbox1=gtk_hbox_new(FALSE,0);
	hbox2=gtk_hbox_new(FALSE,0);
	hbox3=gtk_hbox_new(FALSE,0);
	hbox4=gtk_hbox_new(FALSE,0);
	hbox5=gtk_hbox_new(FALSE,0);
	hbox8=gtk_hbox_new(FALSE,0);
	
	hour=gtk_entry_new();
	min=gtk_entry_new();
	sec=gtk_entry_new();

	duration=gtk_check_button_new_with_label(" Enable Duration Mode");
	seconds=gtk_check_button_new_with_label(" Show Seconds");
	set_button=gtk_button_new_with_label(" Set Time ");
	get_button=gtk_button_new_with_label(" Get Time ");
	set_range_button=gtk_button_new_with_label("Set Duration Range");
	get_range_button=gtk_button_new_with_label("Get Duration Range");
	back_button=gtk_button_new_with_label(" Back ");

	gtk_widget_set_sensitive(set_range_button,FALSE);
        gtk_widget_set_sensitive(get_range_button,FALSE);
	
	/*-------------------Signal Handlers-----------------*/
	g_signal_connect(G_OBJECT(set_button),"clicked",G_CALLBACK(set_call),NULL);
	g_signal_connect(G_OBJECT(get_button),"clicked",G_CALLBACK(get_call),NULL);
	g_signal_connect(G_OBJECT(seconds),"toggled",G_CALLBACK(show_seconds),NULL);
	g_signal_connect(G_OBJECT(duration),"toggled",G_CALLBACK(duration_toggle),NULL);
	g_signal_connect(G_OBJECT(set_range_button),"clicked",G_CALLBACK(set_range),NULL);
	g_signal_connect(G_OBJECT(get_range_button),"clicked",G_CALLBACK(get_range),NULL);
	g_signal_connect(G_OBJECT(back_button),"clicked",G_CALLBACK(on_return),NULL);
	g_signal_connect(G_OBJECT(h_window),"destroy",gtk_main_quit,NULL);
	
	/*---------------------PACKING-------------------------*/
	gtk_box_pack_start(GTK_BOX(vbox),hbox1,FALSE,FALSE,5);	

	gtk_box_pack_start(GTK_BOX(vbox),hbox2,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(hbox2),hour,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(hbox2),min,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(hbox2),sec,FALSE,FALSE,10);
	
	gtk_box_pack_start(GTK_BOX(vbox),hbox3,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(hbox3),duration,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(hbox3),seconds,FALSE,FALSE,10);
	
	gtk_box_pack_start(GTK_BOX(vbox),hbox4,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(hbox4),set_button,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(hbox4),get_button,FALSE,FALSE,10);
	
	gtk_box_pack_start(GTK_BOX(vbox),hbox8,FALSE,FALSE,5);
        gtk_box_pack_start(GTK_BOX(hbox8),set_range_button,FALSE,FALSE,10);
        gtk_box_pack_start(GTK_BOX(hbox8),get_range_button,FALSE,FALSE,10);
	
	gtk_box_pack_start(GTK_BOX(vbox),hbox5,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(hbox5),back_button,FALSE,FALSE,10);
	
	gtk_container_add(GTK_CONTAINER(h_window),vbox);

}
