/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

void properties_call(GtkButton *b, gpointer u_data)
{
	gtk_entry_set_text(GTK_ENTRY(hour),"");
        gtk_entry_set_text(GTK_ENTRY(min),"");
        gtk_entry_set_text(GTK_ENTRY(sec),"");
	gtk_widget_show_all(h_window);
	gtk_widget_hide(window);
}

void set_call(GtkButton *b,gpointer u_data)
{
	gint h,m,s;
	
	h=atoi(gtk_entry_get_text(GTK_ENTRY(hour)));
	m=atoi(gtk_entry_get_text(GTK_ENTRY(min)));
	s=atoi(gtk_entry_get_text(GTK_ENTRY(sec)));

	hildon_time_editor_set_time(HILDON_TIME_EDITOR(h_t_editor),h,m,s);
	
	gtk_widget_hide(h_window);
        gtk_widget_show(window);
}

void get_call(GtkButton *b,gpointer u_data)
{
	guint x,y,z;
	gchar str[20];
	hildon_time_editor_get_time(HILDON_TIME_EDITOR(h_t_editor),&x,&y,&z);
	sprintf(str,"%d",x);
	gtk_entry_set_text(GTK_ENTRY(hour),str);
	sprintf(str,"%d",y);
        gtk_entry_set_text(GTK_ENTRY(min),str);
	sprintf(str,"%d",z);
        gtk_entry_set_text(GTK_ENTRY(sec),str);
}

void show_seconds(GtkWidget *c,gpointer u_data)
{
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(seconds)))
		hildon_time_editor_show_seconds(HILDON_TIME_EDITOR(h_t_editor),TRUE);
	else
		hildon_time_editor_show_seconds(HILDON_TIME_EDITOR(h_t_editor),FALSE);
}	

/*---------Enabling the duration editor-------------*/
void duration_toggle(GtkWidget *c,gpointer u_data)
{
	/*---Hide the seconds field before setting enabling the duration mode....
	  to check whether duration editor hides or shows seconds by defalut-------------*/
//		 hildon_time_editor_show_seconds(HILDON_TIME_EDITOR(h_t_editor),FALSE);
	 
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(duration)))
	{
		hildon_time_editor_enable_duration_mode(HILDON_TIME_EDITOR(h_t_editor),TRUE);
		gtk_widget_set_sensitive(set_range_button,TRUE);
	        gtk_widget_set_sensitive(get_range_button,TRUE);
	}
	else
	{
		hildon_time_editor_enable_duration_mode(HILDON_TIME_EDITOR(h_t_editor),FALSE);
		gtk_widget_set_sensitive(set_range_button,FALSE);
		gtk_widget_set_sensitive(get_range_button,FALSE);
	}
}

/*--------Setting the range of the duration editor in secs-----------*/
void set_range(GtkButton *b,gpointer u_data)
{
	gint minimum,maximum;
	minimum=atoi(gtk_entry_get_text(GTK_ENTRY(hour)));
        maximum=atoi(gtk_entry_get_text(GTK_ENTRY(min)));
	
	hildon_time_editor_set_duration_range(HILDON_TIME_EDITOR(h_t_editor),minimum,maximum);
	
	gtk_widget_hide(h_window);
        gtk_widget_show(window);
}

/*---------Getting the range of the duration editor in secs----------*/
void get_range(GtkButton *b,gpointer u_data)
{
	gint x,y;
	gchar str[20];
	
	hildon_time_editor_get_duration_range(HILDON_TIME_EDITOR(h_t_editor),&x,&y);
	
	sprintf(str,"%d",x);
	gtk_entry_set_text(GTK_ENTRY(hour),str);
	sprintf(str,"%d",y);
	gtk_entry_set_text(GTK_ENTRY(min),str);
}
