/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

void create_window(void)
{

	/* Create the Main Window */
	
	main_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(main_window),10);
	gtk_window_set_title(GTK_WINDOW(main_window),"Telephone Editor App");
	g_signal_connect(G_OBJECT(main_window),"destroy",gtk_main_quit,NULL);

	main_vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(main_window),main_vbox);

	frame=gtk_frame_new("Properties");
	gtk_box_pack_start(GTK_BOX(main_vbox),frame,FALSE,FALSE,0);

	fvbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(frame),fvbox);
	
	/* define the controls */
	
	main_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(fvbox),main_hbox,FALSE,FALSE,0);

	label=gtk_label_new("Set Editable :");
	gtk_box_pack_start(GTK_BOX(main_hbox),label,FALSE,FALSE,0);

	country_check=gtk_check_button_new_with_label("Country");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(country_check),TRUE);
	gtk_box_pack_start(GTK_BOX(main_hbox),country_check,FALSE,FALSE,0);

	area_check=gtk_check_button_new_with_label("Area");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(area_check),TRUE);
	gtk_box_pack_start(GTK_BOX(main_hbox),area_check,FALSE,FALSE,0);

	num_check=gtk_check_button_new_with_label("Number");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(num_check),TRUE);
	gtk_box_pack_start(GTK_BOX(main_hbox),num_check,FALSE,FALSE,0);
	
	main_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(fvbox),main_hbox,FALSE,FALSE,0);

        label=gtk_label_new("Show           :");
        gtk_box_pack_start(GTK_BOX(main_hbox),label,FALSE,FALSE,0);

        border_check=gtk_check_button_new_with_label("Border");
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(border_check),TRUE);
        gtk_box_pack_start(GTK_BOX(main_hbox),border_check,FALSE,FALSE,0);

        plus_check=gtk_check_button_new_with_label("Plus");
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(plus_check),TRUE);
        gtk_box_pack_start(GTK_BOX(main_hbox),plus_check,FALSE,FALSE,0);
	
	launch=gtk_button_new_with_label("Launch Telephone Editor");
	gtk_box_pack_start(GTK_BOX(fvbox),launch,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(launch),"clicked",G_CALLBACK(launch_editor),NULL);
	
	main_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(main_vbox),main_hbox,FALSE,FALSE,0);

	button=gtk_button_new_with_label("Set Width");
	gtk_box_pack_start(GTK_BOX(main_hbox),button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(button),"clicked",G_CALLBACK(set_width),NULL);

	button=gtk_button_new_with_label("Set");
	gtk_box_pack_start(GTK_BOX(main_hbox),button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(button),"clicked",G_CALLBACK(set_field),NULL);

	button=gtk_button_new_with_label("Get");
	gtk_box_pack_start(GTK_BOX(main_hbox),button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(button),"clicked",G_CALLBACK(get_field),NULL);
	
	entry1=gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(entry1),6);
	gtk_box_pack_start(GTK_BOX(main_hbox),entry1,FALSE,FALSE,0);

	entry2=gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(entry2),6);
	gtk_box_pack_start(GTK_BOX(main_hbox),entry2,FALSE,FALSE,0);

	entry3=gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(entry3),6);
	gtk_box_pack_start(GTK_BOX(main_hbox),entry3,FALSE,FALSE,0);

	main_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(fvbox),main_hbox,FALSE,FALSE,0);

	main_combo=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(main_combo),"Border");
	gtk_combo_box_append_text(GTK_COMBO_BOX(main_combo),"Plus");
	gtk_combo_box_set_active(GTK_COMBO_BOX(main_combo),0);
	gtk_box_pack_start(GTK_BOX(main_hbox),main_combo,TRUE,TRUE,5);

	main_get=gtk_button_new_with_label("Get");
	gtk_box_pack_start(GTK_BOX(main_hbox),main_get,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(main_get),"clicked",G_CALLBACK(get_call),NULL);

	main_label=gtk_label_new(" ");
	gtk_box_pack_start(GTK_BOX(main_hbox),main_label,TRUE,TRUE,5);

	quit_button=gtk_button_new_from_stock(GTK_STOCK_QUIT);
	gtk_box_pack_end(GTK_BOX(main_vbox),quit_button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);

	gtk_widget_show_all(main_window);

}

