/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

/*--------Launches the telephone editor widget--------*/
void launch_editor(void)
{

	gint i;

	editor_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(editor_window),10);
	gtk_window_set_title(GTK_WINDOW(editor_window),"Telephone Editor");
	g_signal_connect(G_OBJECT(editor_window),"destroy",G_CALLBACK(home_call),NULL);

        editor_vbox=gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(editor_window),editor_vbox);

	/* define a horizontal group */
	
        group=GTK_SIZE_GROUP(gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL));
	
        /* pack the editors and the associated captions */
	
	phone_editor[0]=hildon_telephone_editor_new_with_strings(HILDON_TELEPHONE_EDITOR_FORMAT_COERCE,"country","area","number");
        caption=hildon_caption_new(group,"Coerce",phone_editor[0],NULL,HILDON_CAPTION_OPTIONAL);
        gtk_box_pack_start(GTK_BOX(editor_vbox),caption,FALSE,FALSE,0);
	
        phone_editor[1]=hildon_telephone_editor_new(HILDON_TELEPHONE_EDITOR_FORMAT_COERCE_AREA);
  	caption=hildon_caption_new(group,"CoerceArea",phone_editor[1],NULL,HILDON_CAPTION_OPTIONAL);
        gtk_box_pack_start(GTK_BOX(editor_vbox),caption,FALSE,FALSE,0);
	
        phone_editor[2]=hildon_telephone_editor_new(HILDON_TELEPHONE_EDITOR_FORMAT_COERCE_COUNTRY);
        caption=hildon_caption_new(group,"CoerceCountry",phone_editor[2],NULL,HILDON_CAPTION_OPTIONAL);
	gtk_box_pack_start(GTK_BOX(editor_vbox),caption,FALSE,FALSE,0);
	
	phone_editor[3]=hildon_telephone_editor_new_with_strings(HILDON_TELEPHONE_EDITOR_FORMAT_FREE,"country","area","number");
	caption=hildon_caption_new(group,"Free",phone_editor[3],NULL,HILDON_CAPTION_OPTIONAL);
	gtk_box_pack_start(GTK_BOX(editor_vbox),caption,FALSE,FALSE,0);

	home_button=gtk_button_new_from_stock(GTK_STOCK_HOME);
	gtk_box_pack_end(GTK_BOX(editor_vbox),home_button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(home_button),"clicked",G_CALLBACK(home_call),NULL);

	for(i=0;i<4;i++)
	{

		hildon_telephone_editor_set_editable(HILDON_TELEPHONE_EDITOR(phone_editor[i]),
				gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(country_check)),
				gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(area_check)),
				gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(num_check)));
	}

        for(i=0;i<4;i++)
		hildon_telephone_editor_set_show_border(HILDON_TELEPHONE_EDITOR(phone_editor[i]),gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(border_check)));
	
        for(i=0;i<4;i++)
	        hildon_telephone_editor_set_show_plus(HILDON_TELEPHONE_EDITOR(phone_editor[i]),gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(plus_check)));
		
	gtk_widget_show_all(editor_window);

}


/*--------Activated on the click of set width button--------*/
void set_width(GtkButton *button,gpointer data)
{

	gint i;

	if(phone_editor[0]==NULL)
		gtk_infoprint(GTK_WINDOW(main_window),"Launch Editor");
	else
	{
		gtk_widget_hide(main_window);
		for(i=0;i<4;i++)
		{
			hildon_telephone_editor_set_widths(HILDON_TELEPHONE_EDITOR(phone_editor[i]),
				atoi(gtk_entry_get_text(GTK_ENTRY(entry1))),
				atoi(gtk_entry_get_text(GTK_ENTRY(entry2))),
				atoi(gtk_entry_get_text(GTK_ENTRY(entry3))));
		}
		gtk_widget_show(editor_window);
	}

}

/*---------Set the values of the phone editor using APIs---------*/
void set_field(GtkButton *button,gpointer data)
{

	gint i;

	if(phone_editor[0]==NULL)
		gtk_infoprint(GTK_WINDOW(main_window),"Launch Editor");
	
	else
	{
		gtk_widget_hide(main_window);
		for(i=0;i<4;i++)
		{

			if(entry1)
				hildon_telephone_editor_set_country(HILDON_TELEPHONE_EDITOR(phone_editor[i]),
					gtk_entry_get_text(GTK_ENTRY(entry1)));
		
			if(entry2)
				hildon_telephone_editor_set_area(HILDON_TELEPHONE_EDITOR(phone_editor[i]),
					gtk_entry_get_text(GTK_ENTRY(entry2)));
	
			if(entry3)
				hildon_telephone_editor_set_number(HILDON_TELEPHONE_EDITOR(phone_editor[i]),
					gtk_entry_get_text(GTK_ENTRY(entry3)));
		}
		gtk_widget_show(editor_window);
	}

}

/*--------------Get the values of the editor---------------*/
void get_field(GtkButton *button, gpointer data)
{

	const gchar *str1,*str2,*str3;

	if(phone_editor[0]==NULL)
		gtk_infoprint(GTK_WINDOW(main_window),"Launch Editor");
	else
	{
		str1=hildon_telephone_editor_get_country(HILDON_TELEPHONE_EDITOR(phone_editor[0]));
		str2=hildon_telephone_editor_get_area(HILDON_TELEPHONE_EDITOR(phone_editor[0]));
		str3=hildon_telephone_editor_get_number(HILDON_TELEPHONE_EDITOR(phone_editor[0]));

		gtk_entry_set_text(GTK_ENTRY(entry1),str1);
		gtk_entry_set_text(GTK_ENTRY(entry2),str2);
		gtk_entry_set_text(GTK_ENTRY(entry3),str3);
	}

}

/*-----------Checks and displays if the border and the plus sign are shown or hidden-----*/
void get_call(void)
{

	gint res;
	gboolean bool1;

	res=gtk_combo_box_get_active(GTK_COMBO_BOX(main_combo));
	if(phone_editor[0]==NULL)
		gtk_infoprint(GTK_WINDOW(main_window),"Launch Editor");
	else
	{
		switch(res)
		{

			case 0 : bool1=hildon_telephone_editor_get_show_border(HILDON_TELEPHONE_EDITOR(phone_editor[0]));
				 if(bool1==TRUE)
					 gtk_label_set_text(GTK_LABEL(main_label),"TRUE");
				 else
					 gtk_label_set_text(GTK_LABEL(main_label),"FALSE");
				 break;

			case 1 : bool1=hildon_telephone_editor_get_show_plus(HILDON_TELEPHONE_EDITOR(phone_editor[0]));
				 if(bool1==TRUE)
					 gtk_label_set_text(GTK_LABEL(main_label),"TRUE");
				 else
					 gtk_label_set_text(GTK_LABEL(main_label),"FALSE");
				 break;

		}
	}
}
					 

/*---------shows the main window with controls-----*/
void home_call(void)
{

	gtk_widget_hide(editor_window);
	gtk_widget_show(main_window);

}



	


		
