/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

/*-----------This function creates the window where the dialog will be displayed--------*/
void second_window(void)
{
	display_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	s_vbox=gtk_vbox_new(FALSE,0);
	s_hbox=gtk_hbox_new(FALSE,0);

	BBack=gtk_button_new_with_label("Back");
	gtk_signal_connect(G_OBJECT(BBack),"clicked",G_CALLBACK(back_call),NULL);
	
	/*--------------Packing-----------------*/
	gtk_box_pack_end(GTK_BOX(s_vbox),s_hbox,0,0,0);
	gtk_box_pack_start(GTK_BOX(s_hbox),BBack,TRUE,0,0);
	gtk_container_add(GTK_CONTAINER(display_window),s_vbox);			
}

/*----------------This function creates the main display window--------------*/
void main_window()
{
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_WINDOW(window), 10);
	
	hbox1=gtk_hbox_new(FALSE, 50);
	hbox2=gtk_hbox_new(FALSE, 50);
	vbox1=gtk_vbox_new(TRUE, 0);
	vbox2=gtk_vbox_new(FALSE, 40);
	vbox3=gtk_vbox_new(FALSE, 6);

	/*----Creates the second window for displaying the sort dialog later-----*/
	second_window();
	
	frame=gtk_frame_new(" ");
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
        gtk_frame_set_label_align(GTK_FRAME(frame), 0.5, 0.5);
	gtk_container_add(GTK_CONTAINER(window), frame);

	align=gtk_alignment_new(0.5, 0.5, 0, 0);
	Blaunch=gtk_button_new_with_label("Launch Sort Dialog");
	gtk_widget_set_usize(GTK_WIDGET(Blaunch), 250, 40);
	gtk_container_add(GTK_CONTAINER(align), Blaunch);
	gtk_box_pack_start(GTK_BOX(vbox2), align, FALSE, 0, 0);

	hsep=gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox2), hsep, FALSE, 0, 0);

	Lsort=gtk_label_new("Sort Type:");
	gtk_widget_set_usize(GTK_WIDGET(Lsort), 250, 40);
	gtk_box_pack_start(GTK_BOX(hbox1), Lsort, TRUE, 0, 0);

	Esort=gtk_entry_new();
	gtk_widget_set_usize(GTK_WIDGET(Esort), 250, 40);
	gtk_box_pack_start(GTK_BOX(hbox1), Esort, TRUE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox1, FALSE, 0, 0);

	Lkey=gtk_label_new("Sort Key:");
        gtk_widget_set_usize(GTK_WIDGET(Lkey), 250, 40);
        gtk_box_pack_start(GTK_BOX(hbox2), Lkey, TRUE, 0, 0);

        Ekey=gtk_entry_new();
        gtk_widget_set_usize(GTK_WIDGET(Ekey), 250, 40);
        gtk_box_pack_start(GTK_BOX(hbox2), Ekey, TRUE, 0, 0);
        gtk_box_pack_start(GTK_BOX(vbox2), hbox2, FALSE, 0, 0);
	
	hsep2=gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(vbox3), hsep2, FALSE, 0, 0);
       
	align=gtk_alignment_new(0.5, 0.5, 0, 0);
	Bexit=gtk_button_new_with_label("Exit");
        gtk_widget_set_usize(GTK_WIDGET(Bexit), 250, 40);
	gtk_container_add(GTK_CONTAINER(align), Bexit);
        gtk_box_pack_start(GTK_BOX(vbox3), align, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox2), vbox3, FALSE, 0, 0);
					 
	gtk_signal_connect(GTK_OBJECT(Blaunch), "clicked",G_CALLBACK(on_launch), NULL);
	gtk_signal_connect(GTK_OBJECT(Bexit), "clicked", gtk_main_quit, NULL);
	
	gtk_container_add(GTK_CONTAINER(vbox1), vbox2);
	gtk_container_add(GTK_CONTAINER(frame), vbox1);
	gtk_widget_show_all(window);
}
	
