/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*-----This function launches the sort dialog when the button "Launch sort Dialog" is clicked-----*/
void on_launch(GtkWidget *button, gpointer data)
{
	gint responseid;
	gtk_widget_show_all(display_window);
	gtk_widget_hide(window);	
	sort_dialog=hildon_sort_dialog_new(NULL);//GTK_WINDOW(display_window));
        int_key1=hildon_sort_dialog_add_sort_key(HILDON_SORT_DIALOG(sort_dialog), "Name");
        int_key2=hildon_sort_dialog_add_sort_key(HILDON_SORT_DIALOG(sort_dialog), "Date");
        int_key3=hildon_sort_dialog_add_sort_key(HILDON_SORT_DIALOG(sort_dialog), "Size");
        hildon_sort_dialog_set_sort_order(HILDON_SORT_DIALOG(sort_dialog), 0);
        hildon_sort_dialog_set_sort_key(HILDON_SORT_DIALOG(sort_dialog), 1);
	responseid=gtk_dialog_run(GTK_DIALOG(sort_dialog));
	if(responseid==GTK_RESPONSE_OK)
	{
		int_sort=hildon_sort_dialog_get_sort_order(HILDON_SORT_DIALOG(sort_dialog));
		int_getkey=hildon_sort_dialog_get_sort_key(HILDON_SORT_DIALOG(sort_dialog));
		if(int_sort==0)
			gtk_entry_set_text(GTK_ENTRY(Esort),"Ascending");
		else if(int_sort==1)
			gtk_entry_set_text(GTK_ENTRY(Esort),"Descending");
		if(int_getkey==0)
                        gtk_entry_set_text(GTK_ENTRY(Ekey), "Name");
                else if(int_getkey==1)
                        gtk_entry_set_text(GTK_ENTRY(Ekey), "Date");
                else if(int_getkey==2)
                        gtk_entry_set_text(GTK_ENTRY(Ekey), "Size");
		
		gtk_widget_hide(display_window);
		gtk_widget_show_all(window);
	}
	else if (responseid==GTK_RESPONSE_CANCEL)
	{
		gtk_entry_set_text(GTK_ENTRY(Ekey),"");
		gtk_entry_set_text(GTK_ENTRY(Esort),"");
		gtk_widget_hide(display_window);
		gtk_widget_show_all(window);
	}
	gtk_widget_destroy(sort_dialog);		
}

/*-------This executes on the click of BACK button-------*/
void back_call(GtkButton *b,gpointer udata)
{
	gtk_widget_hide(display_window);
	gtk_widget_show_all(window);
}
