/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

GtkWidget *h_main_vbox;
GtkWidget *h_text_vbox;
GtkWidget *h_button_vbox;
GtkWidget *h_button_hbox;
GtkWidget *h_get_time_entry;
GtkWidget *h_get_pos_entry;
GtkWidget *h_settime;
GtkWidget *h_gettime;
GtkWidget *h_setposition;
GtkWidget *h_getposition;
GtkWidget *h_quit;
GtkWidget *seekbar_box;

/*----------Sets the total time using the API-------*/
void
h_settime_func(void)
{

gint time;
time = atoi(gtk_entry_get_text(GTK_ENTRY(h_set_time_entry)));

if(time <= 0)
{
	  GtkWidget *dialog_vbox1;
	  GtkWidget *label1;
	  GtkWidget *okbutton1;
		
	  dialog1 = gtk_dialog_new ();
	  gtk_window_set_title (GTK_WINDOW (dialog1), ("Error"));
          gtk_signal_connect (GTK_OBJECT (dialog1), "destroy",
                        GTK_SIGNAL_FUNC (dialog_close), NULL);


	  dialog_vbox1 = GTK_DIALOG (dialog1)->vbox;
	  gtk_widget_show (dialog_vbox1);
	
	  label1 = gtk_label_new ("Please enter set total time value >0");
	  gtk_widget_show (label1);
	  gtk_box_pack_start (GTK_BOX (dialog_vbox1), label1, FALSE, FALSE, 0);
	  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);

	  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
	  gtk_widget_show (okbutton1);
	  gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), okbutton1, GTK_RESPONSE_OK);
	  gtk_widget_show(dialog1);
	  g_signal_connect (G_OBJECT( okbutton1), "clicked",
                    G_CALLBACK (dialog_close),
                    NULL);

}
else
{
        create_main_window();
	hildon_seekbar_set_total_time(h_seekbar,time);
	int pos = atoi(gtk_entry_get_text(GTK_ENTRY(h_set_pos_entry))); 
	hildon_seekbar_set_position(h_seekbar,pos);
        gtk_widget_hide(hvolbar_window);
}
}

/*---------Set the current position using the API------*/
void
h_setpos_func(void)
{
	gint pos;
	pos = atoi(gtk_entry_get_text(GTK_ENTRY(h_set_pos_entry))); 

if(pos < 0)
{
          GtkWidget *dialog_vbox1;
          GtkWidget *label1;
          GtkWidget *okbutton1;

          dialog1 = gtk_dialog_new ();
          gtk_window_set_title (GTK_WINDOW (dialog1), ("Error"));
          gtk_signal_connect (GTK_OBJECT (dialog1), "destroy",
                        GTK_SIGNAL_FUNC (dialog_close), NULL);


          dialog_vbox1 = GTK_DIALOG (dialog1)->vbox;
          gtk_widget_show (dialog_vbox1);

          label1 = gtk_label_new ("Please enter set position value >= 0");
          gtk_widget_show (label1);
          gtk_box_pack_start (GTK_BOX (dialog_vbox1), label1, FALSE, FALSE, 0);
          gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);

          okbutton1 = gtk_button_new_from_stock ("gtk-ok");
          gtk_widget_show (okbutton1);
          gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), okbutton1, GTK_RESPONSE_OK);
          gtk_widget_show(dialog1);
          g_signal_connect (G_OBJECT( okbutton1), "clicked",
                    G_CALLBACK (dialog_close),
                    NULL);

}
else
{
	create_main_window();
	int time = atoi(gtk_entry_get_text(GTK_ENTRY(h_set_time_entry)));
	hildon_seekbar_set_total_time(h_seekbar,time);

	hildon_seekbar_set_position(h_seekbar,pos);
        gtk_widget_hide(hvolbar_window);
}
}


/*------Gets the total time for the seekbar------*/
void
h_gettime_func(GtkButton *button, gpointer user_data)
{

	gchar str[11];
        seektime1 = hildon_seekbar_get_total_time (h_seekbar);
        sprintf(str, "%i",seektime1);
       	gtk_entry_set_text(GTK_ENTRY(h_get_time_entry),str);

}

/*---------Gets the current seekbar position---------*/
void
h_getpos_func(GtkButton *button, gpointer user_data)
{
	gchar str1[11];
        seektime = hildon_seekbar_get_position (h_seekbar);
        sprintf(str1, "%i",seektime);
       	gtk_entry_set_text(GTK_ENTRY(h_get_pos_entry),str1);
}


/*----------Creation of the window that has controls to test the seekbar---------*/
GtkWidget*
create_window (void)
{
  
  hvolbar_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (hvolbar_window), ("Seekbar Testing"));
  
  gtk_signal_connect (GTK_OBJECT (hvolbar_window), "destroy",
                        GTK_SIGNAL_FUNC (gtk_exit), NULL);

  h_main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (hvolbar_window), h_main_vbox);


  h_button_hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (h_main_vbox), h_button_hbox, TRUE, TRUE, 0);

  h_button_vbox = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (h_button_hbox), h_button_vbox, TRUE, TRUE, 0);

  h_settime = gtk_button_new_with_label ("Set Total Time");
  gtk_box_pack_start (GTK_BOX (h_button_vbox), h_settime, TRUE, TRUE, 0);

  h_gettime = gtk_button_new_with_label ("Get Total Time");
  gtk_box_pack_start (GTK_BOX (h_button_vbox), h_gettime, TRUE, TRUE, 0);

  h_setposition = gtk_button_new_with_label ("Set Position");
  gtk_box_pack_start (GTK_BOX (h_button_vbox), h_setposition, TRUE, TRUE, 0);


  h_getposition = gtk_button_new_with_label ("Get Position");
  gtk_box_pack_start (GTK_BOX (h_button_vbox), h_getposition, TRUE, TRUE, 0);

  h_text_vbox = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (h_button_hbox), h_text_vbox, TRUE, TRUE, 0);

  h_set_time_entry = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (h_text_vbox), h_set_time_entry, TRUE, TRUE, 0);
  gtk_editable_set_editable (GTK_ENTRY (h_set_time_entry), TRUE);
                                                                               

  h_get_time_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (h_text_vbox), h_get_time_entry, TRUE, TRUE, 0);
  gtk_editable_set_editable (GTK_EDITABLE (h_get_time_entry), FALSE);
  gtk_entry_set_activates_default (GTK_ENTRY (h_get_time_entry), FALSE);

   h_set_pos_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (h_text_vbox), h_set_pos_entry, TRUE, TRUE, 0);
  gtk_editable_set_editable (GTK_ENTRY(h_set_pos_entry), TRUE);

  h_get_pos_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (h_text_vbox), h_get_pos_entry, TRUE, TRUE, 0);
  gtk_editable_set_editable (GTK_EDITABLE (h_get_pos_entry), FALSE);
  gtk_entry_set_activates_default (GTK_ENTRY (h_get_pos_entry), TRUE);
 
  h_dim=gtk_button_new_with_label("Set insensitive");
  gtk_box_pack_start (GTK_BOX (h_main_vbox), h_dim, TRUE, TRUE, 0);
  g_signal_connect(G_OBJECT(h_dim),"clicked",G_CALLBACK(dim_call),NULL);
  
  h_quit = gtk_button_new_with_mnemonic ("QUIT");
  gtk_box_pack_start (GTK_BOX (h_main_vbox), h_quit, TRUE, TRUE, 0);
                                                                             
  g_signal_connect( G_OBJECT(h_quit), "clicked",
	  G_CALLBACK(gtk_main_quit), NULL);                                                                                

  g_signal_connect (G_OBJECT( h_gettime), "clicked",
                    G_CALLBACK (h_gettime_func),
                    NULL);

  g_signal_connect (G_OBJECT( h_getposition), "clicked",
                    G_CALLBACK (h_getpos_func),
                    NULL);

  g_signal_connect (G_OBJECT (h_settime), "clicked",
                    G_CALLBACK (h_settime_func),
                    NULL);

  g_signal_connect (G_OBJECT (h_setposition), "clicked",
                    G_CALLBACK (h_setpos_func),
                    NULL);

gtk_widget_show_all(hvolbar_window);
}

/*---------Creation of the main window with the widget---------*/
GtkWidget*
create_main_window(void)
{
  GtkWidget *h_main_vbox1;
  GtkWidget *h_gettime1;
  
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), ("Seekbar Testing"));

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                        GTK_SIGNAL_FUNC (gtk_exit), NULL);


  h_main_vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), h_main_vbox1);

  GtkWidget *alignment = gtk_alignment_new(0.5, 0.5, 0, 0);


  seekbar_box = gtk_hbox_new(FALSE, 0);
  gtk_widget_set_size_request(GTK_WIDGET(seekbar_box),-1,200);


  h_seekbar = hildon_seekbar_new ();
  gtk_box_pack_start (GTK_BOX (seekbar_box), GTK_WIDGET(h_seekbar),
                                              FALSE, FALSE, 0);
  hildon_seekbar_set_total_time(GTK_WIDGET(h_seekbar), 600);
  hildon_seekbar_set_position(GTK_WIDGET(h_seekbar), 300);


  gtk_container_add(GTK_CONTAINER(alignment), seekbar_box );
  gtk_box_pack_start (GTK_BOX (h_main_vbox1), alignment,
                          TRUE, TRUE, 0);

  h_gettime1 = gtk_button_new_with_label ("Set Time & Position");
  gtk_box_pack_start (GTK_BOX (h_main_vbox1), h_gettime1, TRUE, TRUE, 0);
  
  g_signal_connect (G_OBJECT( h_gettime1), "clicked",
                    G_CALLBACK (show_main_window),
                    NULL);


  gtk_widget_show_all(window);
}

