/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Creates the main window
void create_main_window (void)
{
	/* create an appview */
	h_app = HILDON_APP(hildon_app_new());
        hildon_app_set_title(h_app,("Search Field"));
 	h_appview = HILDON_APPVIEW(hildon_appview_new("Search Field View"));
	hildon_app_set_appview(h_app,h_appview);
	g_signal_connect(G_OBJECT(h_appview),"destroy",G_CALLBACK(gtk_main_quit),NULL);
        _testSearch(GTK_CONTAINER(&h_appview->parent));
        gtk_widget_show_all(GTK_WIDGET(h_app));
}

//Creates the Search fields
void _testSearch( GtkWidget *parent )
{
    GtkWidget *vbox = gtk_vbox_new( FALSE, 0 );
    GtkWidget *search = hildon_search_new( "hildon-search");
    GtkWidget *search2 = hildon_search_new( NULL );
    GtkWidget *entry, *combo, *button;
    GtkWidget *quit_button;

    counter = 0;

    gtk_container_add( GTK_CONTAINER(parent), vbox);

    button = gtk_button_new_with_label(_("Change icon"));
    gtk_box_pack_start( GTK_BOX(vbox), button, FALSE, FALSE, 0 );
    g_signal_connect( G_OBJECT( button ), "clicked",
                    G_CALLBACK( change_icon ), search);

    /* define an entry box and add it to the search item1 */
    
    entry = gtk_entry_new();
    gtk_container_add( GTK_CONTAINER(search), entry);
    gtk_box_pack_start( GTK_BOX(vbox), search, FALSE, FALSE, 0 );

    /* define a combo box entry and add it to the search item2 */
    combo = gtk_combo_box_entry_new_text();
    
    gtk_combo_box_append_text(GTK_COMBO_BOX(combo), _("First Item"));
    gtk_combo_box_append_text(GTK_COMBO_BOX(combo), _("Second Item"));

    gtk_container_add( GTK_CONTAINER(search2), combo);
    gtk_box_pack_start( GTK_BOX(vbox), search2, FALSE, FALSE, 0 );

    label = gtk_label_new(NULL);
    gtk_box_pack_start( GTK_BOX(vbox), label, FALSE, FALSE, 0 );

    quit_button=gtk_button_new_from_stock(GTK_STOCK_QUIT);
    gtk_box_pack_end(GTK_BOX(vbox),quit_button,FALSE,FALSE,0);
    g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);

    /* add signal connectors to the entry and combo items */
    
    g_signal_connect(G_OBJECT(entry), "activate",
                     (GCallback)&special_key_listener, search);

    g_signal_connect(GTK_ENTRY(GTK_BIN(combo)->child), "changed",
 				(GCallback)&special_key_listener, search2);

    gtk_widget_show_all(vbox);
}
