/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"


void change_icon( GtkWidget *widget, GtkWidget *search )
{
 
    /* Change the icon of the Search Entry Field */
	
    switch ( counter )
    {
        case 0:
            hildon_search_set_image_stock( HILDON_SEARCH(search), "gtk-add" );
            counter++;
            break;
        case 1:
            hildon_search_set_image_stock( HILDON_SEARCH(search), NULL );
            counter++;
            break;
        case 2:
            hildon_search_set_image_stock( HILDON_SEARCH(search), "hildon-search" );
            counter = 0;
            break;
        default:
            break;
    }
}

//Callback on selection of items from the search field
void special_key_listener( GtkEntry *entry, gpointer dataptr )
{
    char buf[120];
    strncpy(buf, _("Searching for: "), 119);
    gtk_label_set_text( GTK_LABEL(label),
        (const char*)strncat(buf, gtk_entry_get_text(GTK_ENTRY(entry)), 120) );
}


